/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.extensions.form;

import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import de.agilecoders.wicket.util.Dates;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateTextFieldConfig
extends AbstractConfig {
    private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    private static final AbstractConfig.IKey<String> StartDate = DateTextFieldConfig.newKey((String)"startDate", null);
    private static final AbstractConfig.IKey<String> EndDate = DateTextFieldConfig.newKey((String)"endDate", null);
    private static final AbstractConfig.IKey<Integer> StartView = DateTextFieldConfig.newKey((String)"startView", (Object)0);
    private static final AbstractConfig.IKey<Boolean> ShowTodayButton = DateTextFieldConfig.newKey((String)"todayBtn", (Object)false);
    private static final AbstractConfig.IKey<Boolean> KeyboardNavigation = DateTextFieldConfig.newKey((String)"keyboardNavigation", (Object)true);
    private static final AbstractConfig.IKey<String> Language = DateTextFieldConfig.newKey((String)"language", (Object)"en");
    private static final AbstractConfig.IKey<String> Format = DateTextFieldConfig.newKey((String)"format", (Object)"mm/dd/yyyy");
    private static final AbstractConfig.IKey<Integer> WeekStart = DateTextFieldConfig.newKey((String)"weekStart", (Object)0);
    private static final AbstractConfig.IKey<Boolean> HighlightToday = DateTextFieldConfig.newKey((String)"todayHighlight", (Object)true);
    private static final AbstractConfig.IKey<Boolean> AutoClose = DateTextFieldConfig.newKey((String)"autoclose", (Object)false);
    private static final AbstractConfig.IKey<Boolean> ForceParse = DateTextFieldConfig.newKey((String)"forceParse", (Object)true);

    public String getFormat() {
        return Dates.toJavaDateFormat((String)this.getString(Format));
    }

    public String getLanguage() {
        return this.getString(Language);
    }

    public boolean isDefaultLanguageSet() {
        return Language.isDefaultValue((Object)this.getLanguage());
    }

    public DateTextFieldConfig withStartDate(DateTime value) {
        this.put(StartDate, value.toString(FORMATTER));
        return this;
    }

    public DateTextFieldConfig withEndDate(DateTime value) {
        this.put(EndDate, value.toString(FORMATTER));
        return this;
    }

    public DateTextFieldConfig withLanguage(String value) {
        this.put(Language, value.toLowerCase());
        return this;
    }

    public DateTextFieldConfig withView(View value) {
        this.put(StartView, value.ordinal());
        return this;
    }

    public DateTextFieldConfig withFormat(String value) {
        this.put(Format, Dates.toJavaScriptDateFormat((String)value));
        return this;
    }

    public DateTextFieldConfig withWeekStart(Day value) {
        this.put(WeekStart, value.ordinal());
        return this;
    }

    public DateTextFieldConfig allowKeyboardNavigation(boolean value) {
        this.put(KeyboardNavigation, value);
        return this;
    }

    public DateTextFieldConfig highlightToday(boolean value) {
        this.put(HighlightToday, value);
        return this;
    }

    public DateTextFieldConfig showTodayButton(boolean value) {
        this.put(ShowTodayButton, value);
        return this;
    }

    public DateTextFieldConfig forceParse(boolean value) {
        this.put(ForceParse, value);
        return this;
    }

    public DateTextFieldConfig autoClose(boolean value) {
        this.put(AutoClose, value);
        return this;
    }

    public static enum View {
        Month,
        Year,
        Decade;

    }

    public static enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;

    }
}

