/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.table;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class TableBehavior
extends BootstrapBaseBehavior {
    private Set<Type> types = Generics2.newHashSet((Object[])new Type[]{Type.Basic});

    public TableBehavior striped() {
        return this.addType(Type.Striped);
    }

    public TableBehavior condensed() {
        return this.addType(Type.Condensed);
    }

    public TableBehavior bordered() {
        return this.addType(Type.Bordered);
    }

    public TableBehavior hover() {
        return this.addType(Type.Hover);
    }

    private TableBehavior addType(Type type) {
        if (!this.types.contains(type)) {
            this.types.add(type);
        }
        return this;
    }

    private Set<String> createCssClassNames() {
        return Generics2.transform(this.types, input -> input != null ? input.cssClassName() : "");
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "table");
        Attributes.addClass(tag, this.createCssClassNames());
    }

    private static enum Type implements ICssClassNameProvider
    {
        Basic,
        Bordered,
        Striped,
        Condensed,
        Hover;


        @Override
        public String cssClassName() {
            return this.equals(Basic) ? "table" : "table-" + this.name().toLowerCase();
        }
    }
}

