/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;

public class BootstrapRadioChoice<T>
extends RadioChoice<T> {
    private boolean inline = false;

    public BootstrapRadioChoice(String id) {
        this(id, new ArrayList());
    }

    public BootstrapRadioChoice(String id, List<? extends T> choices) {
        this(id, choices, (IChoiceRenderer<? extends T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, null, choices, renderer);
    }

    public BootstrapRadioChoice(String id, IModel<T> model, List<? extends T> choices) {
        this(id, (IModel<? extends T>)model, choices, (IChoiceRenderer<? extends T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        this(id, (IModel<? super T>)model, (IModel<List<? super T>>)new WildcardListModel(choices), renderer);
    }

    public BootstrapRadioChoice(String id, IModel<? extends List<? extends T>> choices) {
        this(id, (IModel<List<T>>)choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        this(id, model, (IModel<List<T>>)choices, (IChoiceRenderer<T>)new ChoiceRenderer());
    }

    public BootstrapRadioChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        this(id, null, choices, renderer);
    }

    public BootstrapRadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
        this.setPrefix("<div class=\"radio\">");
        this.setSuffix("</div>");
    }

    public boolean isInline() {
        return this.inline;
    }

    public BootstrapRadioChoice<T> setInline(boolean inline) {
        this.inline = inline;
        return this;
    }

    protected IValueMap getAdditionalAttributesForLabel(int index, T choice) {
        ValueMap attrs = null;
        if (this.isInline()) {
            attrs = new ValueMap();
            attrs.put((Object)"class", (Object)"radio-inline");
        }
        return attrs;
    }

    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
        Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
        String label = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter converter = this.getConverter(objectClass);
            label = converter.convertToString(displayValue, this.getLocale());
        } else if (displayValue != null) {
            label = displayValue.toString();
        }
        if (label != null) {
            IValueMap attrs;
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getMarkupId() + "-" + id;
            buffer.append(this.getPrefix(index, choice));
            boolean enabled = this.isEnabledInHierarchy() && !this.isDisabled(choice, index, selected);
            buffer.append("<label for=\"").append(idAttr).append('\"');
            IValueMap labelAttrs = this.getAdditionalAttributesForLabel(index, choice);
            if (labelAttrs != null) {
                for (Map.Entry attr : labelAttrs.entrySet()) {
                    buffer.append(' ').append((String)attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
                }
            }
            buffer.append('>');
            buffer.append("<input name=\"").append(this.getInputName()).append('\"').append(" type=\"radio\"").append(this.isSelected(choice, index, selected) ? " checked=\"checked\"" : "").append(enabled ? "" : " disabled=\"disabled\"").append(" value=\"").append(id).append("\" id=\"").append(idAttr).append('\"');
            if (this.wantOnSelectionChangedNotifications()) {
                CharSequence url = this.urlFor(IOnChangeListener.INTERFACE, new PageParameters());
                Form form = (Form)this.findParent(Form.class);
                if (form != null) {
                    buffer.append(" onclick=\"").append((Object)form.getJsForInterfaceUrl(url)).append(";\"");
                } else {
                    buffer.append(" onclick=\"window.location.href='").append((Object)url).append((url.toString().indexOf(63) > -1 ? (char)'&' : '?') + this.getInputName()).append('=').append(id).append("';\"");
                }
            }
            if ((attrs = this.getAdditionalAttributes(index, choice)) != null) {
                for (Map.Entry attr : attrs.entrySet()) {
                    buffer.append(' ').append((String)attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
                }
            }
            if (this.getApplication().getDebugSettings().isOutputComponentPath()) {
                CharSequence path = this.getPageRelativePath();
                path = Strings.replaceAll((CharSequence)path, (CharSequence)"_", (CharSequence)"__");
                path = Strings.replaceAll((CharSequence)path, (CharSequence)":", (CharSequence)"_");
                buffer.append(" wicketpath=\"").append((Object)path).append("_input_").append(index).append('\"');
            }
            buffer.append("/>");
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = display;
            if (this.getEscapeModelStrings()) {
                escaped = Strings.escapeMarkup((CharSequence)display);
            }
            buffer.append((Object)escaped).append("</label>");
            buffer.append(this.getSuffix(index, choice));
        }
    }
}

