/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.ProgressBar;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public class Stack
extends GenericPanel<Integer> {
    private Label srOnly;
    private ProgressBar.Type type = ProgressBar.Type.DEFAULT;
    private boolean labeled = false;

    public Stack(String id, IModel<Integer> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.srOnly = new Label("srOnly", this.createLabelModel());
        this.add(new Component[]{this.srOnly});
    }

    public ProgressBar.Type type() {
        return this.type;
    }

    public Stack type(ProgressBar.Type type) {
        this.type = type;
        return this;
    }

    public boolean labeled() {
        return this.labeled;
    }

    public Stack labeled(boolean labeled) {
        this.labeled = labeled;
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.labeled()) {
            this.srOnly.setRenderBodyOnly(true);
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Integer value = (Integer)this.getModelObject();
        Attributes.set(tag, "style", String.format("width: %s%%", value));
        Attributes.set(tag, "aria-valuenow", String.valueOf(value));
        Attributes.set(tag, "aria-valuemin", String.valueOf(0));
        Attributes.set(tag, "aria-valuemax", String.valueOf(100));
        if (!ProgressBar.Type.DEFAULT.equals(this.type)) {
            Attributes.addClass(tag, this.type().cssClassName());
        }
    }

    protected IModel<String> createLabelModel() {
        return new AbstractReadOnlyModel<String>(){

            public String getObject() {
                return String.format("%s%%", Stack.this.getModelObject());
            }
        };
    }
}

