/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.Generics2;
import de.agilecoders.wicket.util.Strings2;
import java.util.List;
import java.util.Set;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public final class CssClassNames {
    private static final Splitter SPLITTER = Splitter.on((char)' ').trimResults().omitEmptyStrings();
    private static final Joiner JOINER = Joiner.on((char)' ').skipNulls();

    public static ICssClassNameProvider newProvider(final IModel<String> model) {
        Args.notNull(model, (String)"model");
        return new ICssClassNameProvider(){

            @Override
            public String cssClassName() {
                return (String)model.getObject();
            }
        };
    }

    private CssClassNames() {
        throw new UnsupportedOperationException();
    }

    public static String join(Iterable<String> classNames) {
        return JOINER.join(classNames);
    }

    public static Set<String> split(CharSequence classValue) {
        return Generics2.newLinkedHashSet(SPLITTER.split(classValue));
    }

    public static Builder newBuilder() {
        return new Builder("");
    }

    public static Builder parse(String classValue) {
        return new Builder(classValue);
    }

    public static final class Builder {
        private final Set<String> classValues = Generics2.newHashSet(new Object[0]);

        private Builder(String classValue) {
            this.addRaw(classValue);
        }

        public Builder addRaw(String rawCssString) {
            this.add(CssClassNames.split(Strings2.nullToEmpty(rawCssString)));
            return this;
        }

        public Builder remove(Builder builder) {
            Args.notNull((Object)builder, (String)"builder");
            return this.remove(builder.asSet());
        }

        public Builder remove(String ... classNames) {
            Args.notNull((Object)classNames, (String)"classNames");
            return this.remove(Generics2.newHashSet(classNames));
        }

        public Builder remove(Set<String> classNames) {
            Args.notNull(classNames, (String)"classNames");
            this.classValues.removeAll(classNames);
            return this;
        }

        public Builder add(Builder builder) {
            Args.notNull((Object)builder, (String)"builder");
            return this.add(builder.asSet());
        }

        public Builder add(String ... classNames) {
            Args.notNull((Object)classNames, (String)"classNames");
            return this.add(Generics2.newHashSet(classNames));
        }

        public Builder add(Set<String> classNames) {
            Args.notNull(classNames, (String)"classNames");
            this.classValues.addAll(classNames);
            return this;
        }

        public String asString() {
            return CssClassNames.join(this.classValues);
        }

        public List<String> asList() {
            return Generics2.newArrayList(this.classValues);
        }

        public Set<String> asSet() {
            return Generics2.newLinkedHashSet(this.classValues);
        }

        public boolean contains(String className) {
            return this.classValues.contains(className);
        }
    }
}

