/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.util;

import de.agilecoders.wicket.util.Generics2;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;

public final class Components {
    private Components() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasTagName(ComponentTag tag, String ... tagNames) {
        return Components.hasTagName(tag, Generics2.newHashSet(tagNames));
    }

    public static boolean hasTagName(ComponentTag tag, Set<? extends String> tagNames) {
        Args.notNull((Object)tag, (String)"tag");
        if (tagNames != null) {
            for (String string : tagNames) {
                if (!tag.getName().equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static void assertTag(Component component, ComponentTag tag, String ... tagNames) {
        Components.assertTag(component, tag, Generics2.newHashSet(tagNames));
    }

    public static void assertTag(Component component, ComponentTag tag, Set<? extends String> tagNames) {
        Args.notNull((Object)component, (String)"component");
        if (!Components.hasTagName(tag, tagNames)) {
            throw Components.createMarkupException(component, tag, tagNames);
        }
    }

    private static MarkupException createMarkupException(Component component, ComponentTag tag, Set<? extends String> tagNames) {
        String msg = String.format("Component [%s] (path = [%s]) must be applied to a tag of type [%s], not: %s", component.getId(), component.getPath(), Generics2.join(tagNames, ','), tag.toUserDebugString());
        throw new MarkupException((IResourceStream)component.getMarkup().getMarkupResourceStream(), msg);
    }

    public static void hideIfModelIsEmpty(Component component) {
        if (component != null && (component.getDefaultModel() == null || component.getDefaultModelObject() == null || Strings.isEmpty((CharSequence)component.getDefaultModelObjectAsString()))) {
            component.setVisible(false);
        }
    }

    public static void show(Component ... components) {
        if (components != null) {
            for (Component component : components) {
                component.setVisible(true);
            }
        }
    }
}

