/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.util;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.CssClassNames;
import de.agilecoders.wicket.util.Generics2;
import java.util.Set;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public final class Attributes {
    public static void addClass(ComponentTag tag, String ... classNames) {
        Args.notNull((Object)classNames, (String)"classNames");
        Attributes.addClass(tag, Generics2.newHashSet(classNames));
    }

    public static void addClass(ComponentTag tag, Set<String> classNames) {
        Args.notNull(classNames, (String)"classNames");
        String classValue = CssClassNames.parse(tag.getAttribute("class")).add(classNames).asString();
        Attributes.set(tag, "class", classValue);
    }

    public static void addClass(ComponentTag tag, ICssClassNameProvider provider) {
        if (provider != null) {
            Attributes.addClass(tag, provider.cssClassName());
        }
    }

    private Attributes() {
        throw new UnsupportedOperationException();
    }

    public static void set(ComponentTag tag, String key, String value) {
        Args.notNull((Object)key, (String)"key");
        if (!Strings.isEmpty((CharSequence)value)) {
            tag.put(key, (CharSequence)value);
        } else {
            tag.remove(key);
        }
    }
}

