/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.settings;

import de.agilecoders.wicket.Bootstrap;
import de.agilecoders.wicket.settings.ActiveThemeProvider;
import de.agilecoders.wicket.settings.ITheme;
import de.agilecoders.wicket.settings.ThemeProvider;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.string.Strings;

public class SessionThemeProvider
implements ActiveThemeProvider {
    private ThemeProvider themeProvider() {
        if (Application.exists()) {
            return Bootstrap.getSettings().getThemeProvider();
        }
        throw new WicketRuntimeException("no application assigned to current thread");
    }

    @Override
    public ITheme getActiveTheme() {
        String style = Session.get().getStyle();
        if (Strings.isEmpty((CharSequence)style)) {
            return this.themeProvider().defaultTheme();
        }
        return this.themeProvider().byName(style);
    }

    @Override
    public void setActiveTheme(String themeName) {
        this.setActiveTheme(this.themeProvider().byName(themeName));
    }

    @Override
    public void setActiveTheme(ITheme theme) {
        this.assertBoundSession();
        if (theme != null) {
            Session.get().setStyle(theme.name());
        } else {
            Session.get().setStyle(null);
        }
    }

    private void assertBoundSession() {
        Session session = Session.get();
        if (session.isTemporary()) {
            session.bind();
        }
    }
}

