/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.navigation;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.Model;

public class BootstrapPagingNavigator
extends PagingNavigator {
    private final Model<String> positionModel = Model.of((Serializable)((Object)Position.Left.cssClassName()));

    public BootstrapPagingNavigator(String markupId, IPageable pageable) {
        this(markupId, pageable, null);
    }

    public BootstrapPagingNavigator(String markupId, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(markupId, pageable, labelProvider);
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "pagination", (String)((Object)this.positionModel.getObject()));
    }

    public BootstrapPagingNavigator setPosition(Position position) {
        this.positionModel.setObject((Serializable)((Object)position.cssClassName()));
        return this;
    }

    public static enum Position implements ICssClassNameProvider
    {
        Left,
        Centered,
        Right;


        @Override
        public String cssClassName() {
            return this.equals(Left) ? "" : "pagination-" + this.name().toLowerCase();
        }
    }
}

