/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.navbar;

import de.agilecoders.wicket.markup.html.bootstrap.common.Invertible;
import de.agilecoders.wicket.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class NavbarAjaxLink<T>
extends AjaxLink<T>
implements Invertible<NavbarAjaxLink<T>> {
    private final Icon icon;
    private final Label label;
    private final IModel<IconType> iconTypeModel = Model.of((Serializable)((Object)IconType.NULL));

    public NavbarAjaxLink() {
        this((IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public NavbarAjaxLink(IModel<String> label) {
        this("component", label);
    }

    public NavbarAjaxLink(String markupId, IModel<String> label) {
        super(markupId);
        this.icon = new Icon("icon", this.iconTypeModel);
        this.label = new Label("label", label);
        this.label.setRenderBodyOnly(true);
        this.add(new Component[]{this.icon, this.label});
    }

    public NavbarAjaxLink<T> setLabel(IModel<String> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public NavbarAjaxLink<T> setIconType(IconType iconType) {
        this.iconTypeModel.setObject((Object)iconType);
        return this;
    }

    @Override
    public NavbarAjaxLink<T> setInverted(boolean inverted) {
        this.icon.setInverted(inverted);
        return this;
    }

    protected IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        if (!"a".equalsIgnoreCase(tag.getName()) && !"button".equalsIgnoreCase(tag.getName())) {
            tag.setName("a");
        }
        super.onComponentTag(tag);
    }
}

