/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.image;

import de.agilecoders.wicket.markup.html.bootstrap.common.Invertible;
import de.agilecoders.wicket.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.util.Attributes;
import de.agilecoders.wicket.util.Components;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class IconBehavior
extends Behavior
implements Invertible<IconBehavior> {
    private final IModel<IconType> type;
    private final IModel<String> value;
    private final IModel<Boolean> invert;

    public IconBehavior(IconType type, boolean invert) {
        this((IModel<IconType>)Model.of((Serializable)((Object)type)), invert);
    }

    public IconBehavior(IModel<IconType> type, boolean invert) {
        this.type = type;
        this.value = Model.of((Serializable)((Object)""));
        this.invert = Model.of((Serializable)Boolean.valueOf(invert));
    }

    public IconBehavior(IconType type) {
        this((IModel<IconType>)Model.of((Serializable)((Object)type)), false);
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "i");
        Attributes.addClass(tag, (String)this.value.getObject());
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (this.hasIconType()) {
            String invertPostfix = this.isInverted() ? " icon-white" : "";
            this.value.setObject((Object)(((IconType)this.type.getObject()).cssClassName() + invertPostfix));
        } else {
            this.value.setObject((Object)"");
            component.setVisible(false);
        }
    }

    public final boolean hasIconType() {
        return this.type != null && this.type.getObject() != null && !IconType.NULL.equals(this.type.getObject());
    }

    public boolean isInverted() {
        return (Boolean)this.invert.getObject();
    }

    public final IconBehavior invert() {
        this.setInverted(true);
        return this;
    }

    public final IconBehavior setType(IconType iconType) {
        this.type.setObject((Object)iconType);
        return this;
    }

    public final IconType type() {
        return (IconType)this.type.getObject();
    }

    @Override
    public IconBehavior setInverted(boolean value) {
        this.invert.setObject((Object)value);
        return this;
    }

    public void detach(Component component) {
        super.detach(component);
        this.invert.detach();
        this.type.detach();
        this.value.detach();
    }
}

