/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.html;

import de.agilecoders.wicket.util.Components;
import de.agilecoders.wicket.util.Generics2;
import de.agilecoders.wicket.util.Strings2;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MetaTag
extends WebMarkupContainer {
    private static final List<String> HTTP_EQUIV_NAMES = Generics2.newArrayList("content-type", "expires", "refresh", "pragma", "cache-control", "content-language", "set-cookie", "PICS-Label", "content-script-type", "content-style-type", "last-modified", "date", "location", "window-target");
    private static final String ATTRIBUTE_NAME_DEFAULT = "name";
    private static final String ATTRIBUTE_NAME_HTTPEQUIV = "http-equiv";
    private static final String ATTRIBUTE_NAME_CONTENT = "content";
    private final IModel<String> name;
    private final IModel<String> content;
    private Type type;

    public MetaTag(String id, String name) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)name)));
    }

    public MetaTag(String id, IModel<String> name) {
        this(id, name, (IModel<String>)Model.of((Serializable)((Object)"")));
    }

    public MetaTag(String id, String name, String content) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)name)), (IModel<String>)Model.of((Serializable)((Object)content)));
    }

    public MetaTag(String id, IModel<String> name, IModel<String> content) {
        super(id);
        this.name = name;
        this.content = content;
        this.type = Type.Detect;
    }

    private Type detect(String name) {
        if (HTTP_EQUIV_NAMES.contains(Strings2.nullToEmpty(name).toLowerCase())) {
            return Type.HttpEquiv;
        }
        return Type.Default;
    }

    public Type type() {
        return this.type;
    }

    public MetaTag type(Type type) {
        this.type = type;
        return this;
    }

    public String name() {
        return (String)this.name.getObject();
    }

    public String content() {
        return (String)this.content.getObject();
    }

    public MetaTag content(String content) {
        this.content.setObject((Object)content);
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "meta");
    }

    protected void onConfigure() {
        super.onConfigure();
        String nameAttribute = ATTRIBUTE_NAME_DEFAULT;
        if (Type.Detect.equals((Object)this.type)) {
            nameAttribute = Type.Default.equals((Object)this.detect(this.name())) ? ATTRIBUTE_NAME_DEFAULT : ATTRIBUTE_NAME_HTTPEQUIV;
        } else if (Type.HttpEquiv.equals((Object)this.type())) {
            nameAttribute = ATTRIBUTE_NAME_HTTPEQUIV;
        }
        this.add(new Behavior[]{new AttributeModifier(nameAttribute, (Serializable)((Object)this.name()))});
        this.add(new Behavior[]{new AttributeModifier(ATTRIBUTE_NAME_CONTENT, (Serializable)((Object)this.content()))});
    }

    public static enum Type {
        Detect,
        Default,
        HttpEquiv;

    }
}

