/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.components;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import de.agilecoders.wicket.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.util.JQuery;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;

public class TooltipBehavior
extends BootstrapJavascriptBehavior {
    private final IModel<String> label;
    private final TooltipConfig config;

    public TooltipBehavior(IModel<String> label) {
        this(label, new TooltipConfig());
    }

    public TooltipBehavior(IModel<String> label, TooltipConfig config) {
        this.label = label;
        this.config = config;
    }

    public void detach(Component component) {
        super.detach(component);
        this.label.detach();
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
        component.add(new Behavior[]{AttributeModifier.replace((String)"rel", (Serializable)((Object)this.createRelAttribute()))});
        component.add(new Behavior[]{AttributeModifier.replace((String)"title", this.label)});
    }

    protected String createRelAttribute() {
        return "tooltip";
    }

    @Override
    public void renderHead(Component component, IHeaderResponse headerResponse) {
        super.renderHead(component, headerResponse);
        headerResponse.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(component, this.config)));
    }

    protected CharSequence createInitializerScript(Component component, AbstractConfig config) {
        return JQuery.$(component).chain("tooltip", config).get();
    }
}

