/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.components;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.CssClassNameModifier;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.Components;
import de.agilecoders.wicket.util.Generics2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ProgressBar
extends Panel {
    private static final int MIN = 0;
    private static final int MAX = 100;
    private Component indicator;
    private boolean active = false;
    private Type type = Type.DEFAULT;
    private boolean striped = false;

    public ProgressBar(String id) {
        super(id, (IModel)Model.of((Serializable)Integer.valueOf(0)));
        this.commonInit();
    }

    public ProgressBar(String id, IModel<Integer> model) {
        super(id, model);
        this.commonInit();
    }

    private void commonInit() {
        this.indicator = this.newIndicator("indicator");
        this.add(new Component[]{this.indicator});
    }

    protected final Component indicator() {
        return this.indicator;
    }

    public boolean striped() {
        return this.striped;
    }

    public ProgressBar striped(boolean value) {
        this.striped = value;
        return this;
    }

    public boolean active() {
        return this.active;
    }

    public ProgressBar active(boolean value) {
        this.active = value;
        return this;
    }

    public final boolean complete() {
        return this.value() == 100;
    }

    public Type type() {
        return this.type;
    }

    public ProgressBar type(Type type) {
        this.type = type;
        return this;
    }

    private Component newIndicator(String markupId) {
        return new WebMarkupContainer(markupId){

            protected void onConfigure() {
                super.onConfigure();
                this.add(new Behavior[]{new AttributeModifier("style", ProgressBar.this.createStyleValue())});
            }
        };
    }

    private IModel<String> createStyleValue() {
        return Model.of((Serializable)((Object)("width: " + this.value() + "%")));
    }

    public ProgressBar value(IModel<Integer> value) {
        this.setDefaultModel(value);
        return this;
    }

    public ProgressBar value(Integer value) {
        this.setDefaultModelObject(value);
        return this;
    }

    public Integer value() {
        return Math.max(Math.min((Integer)this.getDefaultModelObject(), 100), 0);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.add(new Behavior[]{new CssClassNameModifier(this.cssClassNames())});
    }

    private List<String> cssClassNames() {
        ArrayList<String> classNames = Generics2.newArrayList("progress", this.type().cssClassName());
        if (this.active()) {
            classNames.add("active");
        }
        if (this.striped()) {
            classNames.add("progress-striped");
        }
        return classNames;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Components.assertTag((Component)this, tag, "div");
    }

    public static enum Type implements ICssClassNameProvider
    {
        DEFAULT,
        INFO,
        SUCCESS,
        WARNING,
        DANGER;


        @Override
        public String cssClassName() {
            return this.equals(DEFAULT) ? "" : "progress-" + this.name().toLowerCase();
        }

        public CssClassNameAppender newCssClassNameModifier() {
            return new CssClassNameAppender(this.cssClassName());
        }
    }
}

