/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.components;

import de.agilecoders.wicket.markup.html.bootstrap.common.AbstractConfig;
import de.agilecoders.wicket.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.markup.html.bootstrap.components.TooltipBehavior;
import de.agilecoders.wicket.util.JQuery;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;

public class PopoverBehavior
extends TooltipBehavior {
    private final IModel<String> body;

    public PopoverBehavior(IModel<String> label, IModel<String> body) {
        this(label, body, new PopoverConfig());
    }

    public PopoverBehavior(IModel<String> label, IModel<String> body, PopoverConfig config) {
        super(label, config);
        this.body = body;
    }

    @Override
    public void bind(Component component) {
        super.bind(component);
        component.add(new Behavior[]{AttributeModifier.replace((String)"data-content", this.newContent())});
    }

    @Override
    public void detach(Component component) {
        super.detach(component);
        if (this.body != null) {
            this.body.detach();
        }
    }

    @Override
    protected String createRelAttribute() {
        return "popover";
    }

    protected IModel<String> newContent() {
        return this.body;
    }

    @Override
    protected CharSequence createInitializerScript(Component component, AbstractConfig config) {
        return JQuery.$(component).chain("popover", config).get();
    }
}

