/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.markup.html.bootstrap.block;

import de.agilecoders.wicket.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.util.Attributes;
import de.agilecoders.wicket.util.Components;
import de.agilecoders.wicket.util.CssClassNames;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class WellBehavior
extends Behavior {
    private final IModel<Size> size;

    public WellBehavior() {
        this(Size.Default);
    }

    public WellBehavior(Size size) {
        this((IModel<Size>)Model.of((Serializable)((Object)size)));
    }

    public WellBehavior(IModel<Size> sizeModel) {
        this.size = sizeModel;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, CssClassNames.parse("well").add(((Size)this.size.getObject()).cssClassName()).asSet());
        Components.assertTag(component, tag, "div", "span");
    }

    public final WellBehavior setSize(Size size) {
        this.size.setObject((Object)size);
        return this;
    }

    public final Size getSize() {
        return (Size)this.size.getObject();
    }

    public void detach(Component component) {
        super.detach(component);
        this.size.detach();
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }

    public static enum Size implements ICssClassNameProvider
    {
        Default,
        Small,
        Large;


        @Override
        public String cssClassName() {
            return this.equals(Default) ? "" : "well-" + this.name().toLowerCase();
        }
    }
}

