/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navigation;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.jquery.util.Json;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;

public class InfiniteScrollingBehavior
extends Behavior {
    private static final ResourceReference JS = new JQueryPluginResourceReference(InfiniteScrollingBehavior.class, "js/jquery.infinitescroll.js");
    private boolean autoScroll = true;
    private final Map<String, Object> jsonData = new HashMap<String, Object>();

    public InfiniteScrollingBehavior() {
        this.jsonData.put("localMode", true);
        this.jsonData.put("animate", true);
    }

    public void renderHead(Component component, IHeaderResponse headerResponse) {
        super.renderHead(component, headerResponse);
        headerResponse.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JS));
        headerResponse.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(component)));
    }

    protected CharSequence createScript(Component component) {
        String script = "$('#" + component.getMarkupId() + "').infinitescroll(" + Json.stringify(this.jsonData) + ",function(a){});";
        if (!this.autoScroll) {
            script = script + "$(window).unbind('.infscr');";
            script = script + "$('" + this.jsonData.get("nextSelector") + "').click(function() {" + "            $(document).trigger('retrieve.infscr');" + "            return false;" + "       });";
        }
        return script;
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }

    public InfiniteScrollingBehavior setNextSelector(Component component) {
        component.setOutputMarkupId(true);
        this.jsonData.put("nextSelector", "#" + Strings2.getMarkupId((Component)component));
        return this;
    }

    public InfiniteScrollingBehavior setNavSelector(Component component) {
        component.setOutputMarkupId(true);
        this.jsonData.put("navSelector", "#" + Strings2.getMarkupId((Component)component));
        return this;
    }

    public InfiniteScrollingBehavior setItemSelector(Component component, String selector) {
        component.setOutputMarkupId(true);
        this.jsonData.put("itemSelector", "#" + component.getMarkupId() + " " + selector);
        return this;
    }

    public InfiniteScrollingBehavior setContentSelector(Component component) {
        component.setOutputMarkupId(true);
        this.jsonData.put("contentSelector", "#" + Strings2.getMarkupId((Component)component));
        return this;
    }

    public InfiniteScrollingBehavior useAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
        return this;
    }

    public InfiniteScrollingBehavior animate(boolean animate) {
        this.jsonData.put("animate", animate);
        return this;
    }

    public InfiniteScrollingBehavior debug(boolean debug) {
        this.jsonData.put("debug", debug);
        return this;
    }

    public InfiniteScrollingBehavior loadingFinishedMsg(String finishedMsg) {
        this.getLoadingData().put("finishedMsg", finishedMsg);
        return this;
    }

    public InfiniteScrollingBehavior loadingMsgText(String msgText) {
        this.getLoadingData().put("msgText", msgText);
        return this;
    }

    public InfiniteScrollingBehavior loadingImg(String img) {
        this.getLoadingData().put("img", img);
        return this;
    }

    private Map<String, Object> getLoadingData() {
        HashMap loading = (HashMap)this.jsonData.get("loading");
        if (loading == null) {
            loading = new HashMap();
            this.jsonData.put("loading", loading);
        }
        return loading;
    }
}

