/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.webjars.collectors;

import de.agilecoders.wicket.webjars.collectors.JarAssetPathCollector;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import de.agilecoders.wicket.webjars.vfs.ExtendedUrlTypeVFS;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.vfs.VirtualFile;
import org.reflections.vfs.Vfs;

public class VfsJarAssetPathCollector
extends JarAssetPathCollector {
    private static final Pattern PATTERN = Pattern.compile("/([^/]*\\.jar)");
    private static AtomicBoolean added = new AtomicBoolean(false);

    public VfsJarAssetPathCollector() {
        super("vfs", "vfszip", "vfsfile");
        VfsJarAssetPathCollector.addDefaultUrlTypes();
    }

    @Override
    protected JarFile newJarFile(URL url) {
        try {
            URLConnection conn = url.openConnection();
            VirtualFile vf = (VirtualFile)conn.getContent();
            File contentsFile = vf.getPhysicalFile();
            String c = contentsFile.getPath().replace('\\', '/');
            String jarName = VfsJarAssetPathCollector.toJarName(url);
            String pathToJar = c.substring(0, c.indexOf("/contents/"));
            return new JarFile(new File(pathToJar, jarName));
        }
        catch (IOException e) {
            throw new WebJarAssetLocator.ResourceException(url.toString(), e.getMessage());
        }
    }

    private static String toJarName(URL url) {
        String path = url.getPath();
        Matcher m = PATTERN.matcher(path);
        if (m.find()) {
            return m.group(1);
        }
        throw new WebJarAssetLocator.ResourceException(path, "given url isn't a jar file");
    }

    private static void addDefaultUrlTypes() {
        if (!added.getAndSet(true)) {
            Vfs.addDefaultURLTypes((Vfs.UrlType)new ExtendedUrlTypeVFS());
        }
    }
}

