/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.RawSerializer;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.ConfigModel;
import java.io.IOException;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public final class Json {
    private Json() {
        throw new UnsupportedOperationException();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        SimpleModule wbModule = new SimpleModule("wicket-bootstrap", new Version(1, 0, 0, null, "de.agilecoders.wicket", "wicket-bootstrap-core"));
        wbModule.addSerializer(ConfigModel.class, (JsonSerializer)new JsonSerializer<ConfigModel>(){

            public void serialize(ConfigModel value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeString(value.getObject());
            }
        });
        wbModule.addSerializer(AbstractConfig.class, (JsonSerializer)new JsonSerializer<AbstractConfig>(){

            public void serialize(AbstractConfig value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeObject((Object)value.toJsonString());
            }
        });
        wbModule.addSerializer(RawValue.class, (JsonSerializer)new RawSerializer<RawValue>(RawValue.class){

            public void serialize(RawValue value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
                jsonGenerator.writeObject((Object)value.value);
            }
        });
        mapper.registerModule((Module)wbModule);
        return mapper;
    }

    public static JsonNode toJson(Object data) {
        if (data == null) {
            return Json.newObject();
        }
        try {
            return Json.createObjectMapper().valueToTree(data);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(JsonNode json, Class<T> clazz) {
        try {
            return (T)Json.createObjectMapper().treeToValue((TreeNode)json, clazz);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        try {
            return (T)Json.createObjectMapper().readValue(json, type);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return Json.fromJson(Json.parse(json), clazz);
    }

    public static ObjectNode newObject() {
        return Json.createObjectMapper().createObjectNode();
    }

    public static String stringify(JsonNode json) {
        return json != null ? json.toString() : "{}";
    }

    public static String stringify(Object data) {
        return Json.stringify(Json.toJson(data));
    }

    public static boolean isValid(String json) {
        if (Strings.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            return Json.parse(json) != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static JsonNode parse(String jsonString) {
        if (Strings.isEmpty((CharSequence)jsonString)) {
            return Json.newObject();
        }
        try {
            return (JsonNode)Json.createObjectMapper().readValue(jsonString, JsonNode.class);
        }
        catch (Throwable e) {
            throw new ParseException(String.format("can't parse string [%s]", jsonString), e);
        }
    }

    public static final class RawValue
    implements IClusterable {
        private final String value;

        public RawValue(String value) {
            this.value = (String)Args.notEmpty((CharSequence)value, (String)"value");
        }
    }

    public static final class ParseException
    extends RuntimeException {
        public ParseException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public ParseException(Throwable throwable) {
            super(throwable);
        }
    }
}

