/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Generics2 {
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        return Lists.newArrayList((Object[])elements);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<? extends T> elements) {
        return Lists.newArrayList(elements);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> elements) {
        return Lists.newArrayList(elements);
    }

    public static <T> Set<T> newLinkedHashSet(Iterable<? extends T> elements) {
        return Sets.newLinkedHashSet(elements);
    }

    public static <T> Set<T> newHashSet(T ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    public static String join(Iterable<?> elements, char separator) {
        return Joiner.on((char)separator).skipNulls().join(elements);
    }

    public static <T> List<T> transform(T[] elements) {
        return Generics2.newArrayList(elements);
    }

    public static <P, R> List<R> transform(List<P> elements, Function<P, R> transformer) {
        return Lists.transform(elements, transformer);
    }

    public static <P, R> Set<R> transform(Set<P> elements, Function<P, R> transformer) {
        return Sets.newHashSet(Generics2.transform(Generics2.newArrayList(elements), transformer));
    }

    public static <P, R> List<R> transform(P[] elements, Function<P, R> transformer) {
        return Lists.transform(Generics2.newArrayList(elements), transformer);
    }

    public static <T> List<T> filter(Iterable<T> unfiltered, Predicate<T> filter) {
        return Generics2.newArrayList(Iterables.filter(unfiltered, filter));
    }

    public static List<String> split(CharSequence value, String separator) {
        return Generics2.newArrayList(Splitter.on((String)separator).omitEmptyStrings().trimResults().split(value));
    }

    private Generics2() {
        throw new UnsupportedOperationException();
    }
}

