/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.pers.jcloud.repository;

import de.adorsys.multibanking.domain.AccountAnalyticsEntity;
import de.adorsys.multibanking.pers.jcloud.domain.UserMainRecord;
import de.adorsys.multibanking.pers.spi.repository.AnalyticsRepositoryIf;
import de.adorsys.multibanking.pers.utils.ObjectPersistenceAdapter;
import de.adorsys.multibanking.pers.utils.UserDataNamingPolicy;
import java.util.Optional;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsRepositoryImpl
implements AnalyticsRepositoryIf {
    @Autowired
    private KeyCredentials keyCredentials;
    @Autowired
    private UserDataNamingPolicy namingPolicy;
    @Autowired
    private ObjectPersistenceAdapter objectPersistenceAdapter;

    public Optional<AccountAnalyticsEntity> findLastByUserIdAndAccountId(String userId, String bankAccountId) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        AccountAnalyticsEntity accountAnalyticsEntity = userMainRecord.getAnalytics().get(bankAccountId);
        if (accountAnalyticsEntity == null) {
            return Optional.empty();
        }
        return Optional.of(accountAnalyticsEntity);
    }

    public void save(AccountAnalyticsEntity accountAnalyticsEntity) {
        ObjectHandle userMainRecordhandle = this.namingPolicy.handleForUserMainRecord(this.keyCredentials);
        UserMainRecord userMainRecord = this.objectPersistenceAdapter.load(userMainRecordhandle, UserMainRecord.class, this.keyCredentials);
        accountAnalyticsEntity.setId(accountAnalyticsEntity.getAccountId());
        userMainRecord.getAnalytics().put(accountAnalyticsEntity.getAccountId(), accountAnalyticsEntity);
    }
}

