/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.pers.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.pers.jcloud.domain.UserBookingRecord;
import de.adorsys.multibanking.pers.jcloud.domain.UserMainRecord;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.service.EncObjectService;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObjectPersistenceAdapter {
    @Autowired
    private EncObjectService encObjectService;
    private ObjectMapper objectMapper = new ObjectMapper();

    public <T> T load(ObjectHandle handle, Class<T> klass, KeyCredentials keyCredentials) {
        byte[] src = null;
        try {
            src = this.encObjectService.readObject(keyCredentials, handle);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeyCredentialException | WrongKeystoreCredentialException e) {
            throw new IllegalStateException(e);
        }
        try {
            return (T)this.objectMapper.readValue(src, klass);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void store(ObjectHandle userMainRecordhandle, UserMainRecord userMainRecord, KeyCredentials keyCredentials) {
        this.storeInternal(userMainRecordhandle, userMainRecord, keyCredentials);
    }

    public void store(ObjectHandle userBookingRecordhandle, UserBookingRecord userBookingRecord, KeyCredentials keyCredentials) {
        this.storeInternal(userBookingRecordhandle, userBookingRecord, keyCredentials);
    }

    private void storeInternal(ObjectHandle handle, Object obj, KeyCredentials keyCredentials) {
        try {
            byte[] data = this.objectMapper.writeValueAsBytes(obj);
            this.encObjectService.writeObject(data, null, handle, keyCredentials);
        }
        catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | ObjectNotFoundException | UnknownContainerException | WrongKeyCredentialException | WrongKeystoreCredentialException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
            throw new IllegalStateException(e);
        }
    }
}

