/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.provided;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import java.security.Key;
import java.util.function.Supplier;
import lombok.NonNull;

public class ProvidedKey
implements ProvidedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final Key key;
    private final KeyMetadata metadata;

    ProvidedKey(@NonNull KeyTemplate keyTemplate, @NonNull Key key, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.key = key;
    }

    ProvidedKey(String alias, String prefix, Supplier<char[]> password, @NonNull Key key, KeyMetadata metadata) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.key = key;
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).key(this.key).metadata(this.metadata);
    }

    public static ProvidedKeyBuilder with() {
        return new ProvidedKeyBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public Key getKey() {
        return this.key;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public String getAlgorithm() {
        return this.getKey().getAlgorithm();
    }

    public String getFormat() {
        return this.getKey().getFormat();
    }

    public byte[] getEncoded() {
        return this.getKey().getEncoded();
    }

    public static class ProvidedKeyBuilder {
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private Key key;
        private KeyMetadata metadata;

        ProvidedKeyBuilder() {
        }

        public ProvidedKeyBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ProvidedKeyBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ProvidedKeyBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public ProvidedKeyBuilder key(@NonNull Key key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public ProvidedKeyBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKey build() {
            return new ProvidedKey(this.alias, this.prefix, this.password, this.key, this.metadata);
        }

        public String toString() {
            return "ProvidedKey.ProvidedKeyBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", key=" + this.key + ", metadata=" + this.metadata + ")";
        }
    }

    public static class Templated {
        private KeyTemplate keyTemplate;
        private Key key;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated key(@NonNull Key key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKey build() {
            return new ProvidedKey(this.keyTemplate, this.key, this.metadata);
        }

        public String toString() {
            return "ProvidedKey.Templated(keyTemplate=" + this.keyTemplate + ", key=" + this.key + ", metadata=" + this.metadata + ")";
        }
    }
}

