/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.KeyPairEncryptionTemplate;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class Signing
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyPairEncryptionTemplate encryptionTemplate;
    private final KeyMetadata metadata;

    public Collection<Signing> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Signing(@NonNull KeyTemplate keyTemplate, @NonNull KeyPairEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Signing(String alias, String prefix, Supplier<char[]> password, String algo, String sigAlgo, Integer keySize, KeyMetadata metadata, String commonName) {
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = KeyPairEncryptionTemplate.of(algo, keySize, sigAlgo, commonName);
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    public static SigningBuilder with() {
        return new SigningBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public KeyPairEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    public int getSize() {
        return this.getEncryptionTemplate().getSize();
    }

    public String getSigAlgo() {
        return this.getEncryptionTemplate().getSigAlgo();
    }

    public String getCommonName() {
        return this.getEncryptionTemplate().getCommonName();
    }

    public static class SigningBuilder {
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private String algo;
        private String sigAlgo;
        private Integer keySize;
        private KeyMetadata metadata;
        private String commonName;

        SigningBuilder() {
        }

        public SigningBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public SigningBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public SigningBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public SigningBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        public SigningBuilder sigAlgo(String sigAlgo) {
            this.sigAlgo = sigAlgo;
            return this;
        }

        public SigningBuilder keySize(Integer keySize) {
            this.keySize = keySize;
            return this;
        }

        public SigningBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public SigningBuilder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public Signing build() {
            return new Signing(this.alias, this.prefix, this.password, this.algo, this.sigAlgo, this.keySize, this.metadata, this.commonName);
        }

        public String toString() {
            return "Signing.SigningBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", algo=" + this.algo + ", sigAlgo=" + this.sigAlgo + ", keySize=" + this.keySize + ", metadata=" + this.metadata + ", commonName=" + this.commonName + ")";
        }
    }

    public static class Templated {
        private KeyTemplate keyTemplate;
        private KeyPairEncryptionTemplate encryptionTemplate;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated encryptionTemplate(@NonNull KeyPairEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Signing build() {
            return new Signing(this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        public String toString() {
            return "Signing.Templated(keyTemplate=" + this.keyTemplate + ", encryptionTemplate=" + this.encryptionTemplate + ", metadata=" + this.metadata + ")";
        }
    }
}

