/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.entity;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import lombok.NonNull;

public class WithMetadata<T> {
    @NonNull
    private final T key;
    private final KeyMetadata metadata;
    private final boolean metadataEntry;

    WithMetadata(@NonNull T key, KeyMetadata metadata, boolean metadataEntry) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.metadata = metadata;
        this.metadataEntry = metadataEntry;
    }

    public static <T> WithMetadataBuilder<T> builder() {
        return new WithMetadataBuilder();
    }

    @NonNull
    public T getKey() {
        return this.key;
    }

    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isMetadataEntry() {
        return this.metadataEntry;
    }

    public static class WithMetadataBuilder<T> {
        private T key;
        private KeyMetadata metadata;
        private boolean metadataEntry;

        WithMetadataBuilder() {
        }

        public WithMetadataBuilder<T> key(@NonNull T key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public WithMetadataBuilder<T> metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public WithMetadataBuilder<T> metadataEntry(boolean metadataEntry) {
            this.metadataEntry = metadataEntry;
            return this;
        }

        public WithMetadata<T> build() {
            return new WithMetadata<T>(this.key, this.metadata, this.metadataEntry);
        }

        public String toString() {
            return "WithMetadata.WithMetadataBuilder(key=" + this.key + ", metadata=" + this.metadata + ", metadataEntry=" + this.metadataEntry + ")";
        }
    }
}

