/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.android.securestoragelibrary;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import de.adorsys.android.securestoragelibrary.R;
import de.adorsys.android.securestoragelibrary.SecureStorageException;
import de.adorsys.android.securestoragelibrary.SecureStorageProvider;
import de.adorsys.android.securestoragelibrary.a;
import java.util.HashSet;
import java.util.Set;

public final class SecurePreferences {
    private static final String KEY_SHARED_PREFERENCES_NAME = "SecurePreferences";
    private static final String KEY_SET_COUNT_POSTFIX = "_count";

    private SecurePreferences() {
    }

    public static void setValue(@NonNull String string2, @NonNull String string3) {
        String string4;
        if (!a.a()) {
            a.b();
        }
        if (TextUtils.isEmpty((CharSequence)(string4 = a.a(string3)))) {
            throw new SecureStorageException(((Context)SecureStorageProvider.a.get()).getString(R.string.message_problem_encryption), null, SecureStorageException.ExceptionType.CRYPTO_EXCEPTION);
        }
        SecurePreferences.setSecureValue(string2, string4);
    }

    public static void setValue(@NonNull String string2, boolean bl) {
        SecurePreferences.setValue(string2, String.valueOf(bl));
    }

    public static void setValue(@NonNull String string2, float f) {
        SecurePreferences.setValue(string2, String.valueOf(f));
    }

    public static void setValue(@NonNull String string2, long l) {
        SecurePreferences.setValue(string2, String.valueOf(l));
    }

    public static void setValue(@NonNull String string2, int n) {
        SecurePreferences.setValue(string2, String.valueOf(n));
    }

    public static void setValue(@NonNull String string2, @NonNull Set<String> set) {
        SecurePreferences.setValue(string2 + KEY_SET_COUNT_POSTFIX, String.valueOf(set.size()));
        int n = 0;
        for (String string3 : set) {
            SecurePreferences.setValue(string2 + "_" + n++, string3);
        }
    }

    @Nullable
    public static String getStringValue(@NonNull String string2, @Nullable String string3) {
        String string4 = SecurePreferences.getSecureValue(string2);
        try {
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                return a.b(string4);
            }
            return string3;
        }
        catch (SecureStorageException secureStorageException) {
            return string3;
        }
    }

    public static boolean getBooleanValue(@NonNull String string2, boolean bl) {
        return Boolean.parseBoolean(SecurePreferences.getStringValue(string2, String.valueOf(bl)));
    }

    public static float getFloatValue(@NonNull String string2, float f) {
        return Float.parseFloat(SecurePreferences.getStringValue(string2, String.valueOf(f)));
    }

    public static long getLongValue(@NonNull String string2, long l) {
        return Long.parseLong(SecurePreferences.getStringValue(string2, String.valueOf(l)));
    }

    public static int getIntValue(@NonNull String string2, int n) {
        return Integer.parseInt(SecurePreferences.getStringValue(string2, String.valueOf(n)));
    }

    @NonNull
    public static Set<String> getStringSetValue(@NonNull String string2, @NonNull Set<String> set) {
        int n = SecurePreferences.getIntValue(string2 + KEY_SET_COUNT_POSTFIX, -1);
        if (n == -1) {
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(SecurePreferences.getStringValue(string2 + "_" + i, ""));
        }
        return hashSet;
    }

    public static boolean contains(@NonNull String string2) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        return sharedPreferences.contains(string2);
    }

    public static void removeValue(@NonNull String string2) {
        SecurePreferences.removeSecureValue(string2);
    }

    public static void clearAllValues() {
        if (a.a()) {
            a.c();
        }
        SecurePreferences.clearAllSecureValues();
    }

    public static void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        sharedPreferences.registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    public static void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        sharedPreferences.unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    private static void setSecureValue(@NonNull String string2, @NonNull String string3) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        sharedPreferences.edit().putString(string2, string3).apply();
    }

    @Nullable
    private static String getSecureValue(@NonNull String string2) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        return sharedPreferences.getString(string2, null);
    }

    private static void removeSecureValue(@NonNull String string2) {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        sharedPreferences.edit().remove(string2).apply();
    }

    private static void clearAllSecureValues() {
        SharedPreferences sharedPreferences = ((Context)SecureStorageProvider.a.get()).getSharedPreferences(KEY_SHARED_PREFERENCES_NAME, 0);
        sharedPreferences.edit().clear().apply();
    }
}

