/*
 * Decompiled with CFR 0.152.
 */
package de.adesso.wickedcharts.chartjs.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.adesso.wickedcharts.chartjs.chartoptions.CallbackFunction;
import de.adesso.wickedcharts.chartjs.chartoptions.JavaScriptReference;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.HexColor;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.RgbColor;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.RgbaColor;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.SimpleColor;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.StringValueColor;
import de.adesso.wickedcharts.chartjs.chartoptions.fillingmodes.FillingMode;
import de.adesso.wickedcharts.chartjs.chartoptions.label.ConstLabel;
import de.adesso.wickedcharts.chartjs.chartoptions.label.DateTimeLabel;
import de.adesso.wickedcharts.chartjs.chartoptions.label.TextLabel;
import de.adesso.wickedcharts.chartjs.chartoptions.label.TextListLabel;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.ConstValue;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.DateTimeValue;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.DoubleValue;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.FloatValue;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.IntegerValue;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.StringValue;
import de.adesso.wickedcharts.chartjs.jackson.SingleElementListObjectMapper;
import de.adesso.wickedcharts.chartjs.jackson.WickedChartsJacksonModule;
import de.adesso.wickedcharts.chartjs.jackson.serializer.CallbackFunctionSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.ConstLabelSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.ConstValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.DateTimeLabelSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.DateTimeValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.DoubleValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.FillingModeSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.FloatValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.HexColorSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.IntegerValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.JavaScriptReferenceSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.JsonValueEnumSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.LowercaseEnumSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.RgbColorSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.RgbaColorSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.SimpleColorSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.StringValueColorSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.StringValueSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.TextLabelSerializer;
import de.adesso.wickedcharts.chartjs.jackson.serializer.TextListLabelSerializer;
import de.adesso.wickedcharts.chartjs.json.JsonValueEnum;
import de.adesso.wickedcharts.chartjs.json.LowercaseEnum;
import java.util.Locale;

public class JsonRenderer {
    private final ObjectMapper jacksonMapper;
    private final WickedChartsJacksonModule jacksonModule = new WickedChartsJacksonModule();
    public static final ObjectMapper DEFAULT_MAPPER = JsonRenderer.createDefaultObjectMapper();

    public JsonRenderer() {
        this.jacksonMapper = this.createJacksonMapper();
    }

    public <T> void addSerializer(Class<T> clazz, JsonSerializer<T> serializer) {
        this.jacksonModule.addSerializer(clazz, serializer);
    }

    private ObjectMapper createJacksonMapper() {
        this.jacksonModule.addSerializer(SimpleColor.class, new SimpleColorSerializer());
        this.jacksonModule.addSerializer(RgbColor.class, new RgbColorSerializer());
        this.jacksonModule.addSerializer(RgbaColor.class, new RgbaColorSerializer());
        this.jacksonModule.addSerializer(JsonValueEnum.class, new JsonValueEnumSerializer());
        this.jacksonModule.addSerializer(LowercaseEnum.class, new LowercaseEnumSerializer());
        this.jacksonModule.addSerializer(StringValueColor.class, new StringValueColorSerializer());
        this.jacksonModule.addSerializer(CallbackFunction.class, new CallbackFunctionSerializer());
        this.jacksonModule.addSerializer(TextLabel.class, new TextLabelSerializer());
        this.jacksonModule.addSerializer(TextListLabel.class, new TextListLabelSerializer());
        this.jacksonModule.addSerializer(DateTimeLabel.class, new DateTimeLabelSerializer());
        this.jacksonModule.addSerializer(IntegerValue.class, new IntegerValueSerializer());
        this.jacksonModule.addSerializer(DoubleValue.class, new DoubleValueSerializer());
        this.jacksonModule.addSerializer(FloatValue.class, new FloatValueSerializer());
        this.jacksonModule.addSerializer(StringValue.class, new StringValueSerializer());
        this.jacksonModule.addSerializer(ConstValue.class, new ConstValueSerializer());
        this.jacksonModule.addSerializer(ConstLabel.class, new ConstLabelSerializer());
        this.jacksonModule.addSerializer(DateTimeValue.class, new DateTimeValueSerializer());
        this.jacksonModule.addSerializer(JavaScriptReference.class, new JavaScriptReferenceSerializer());
        this.jacksonModule.addSerializer(FillingMode.class, new FillingModeSerializer());
        this.jacksonModule.addSerializer(HexColor.class, new HexColorSerializer());
        ObjectMapper mapper = JsonRenderer.createDefaultObjectMapper();
        SingleElementListObjectMapper.getInstance().registerModule((Module)this.jacksonModule);
        mapper.setLocale(Locale.ENGLISH);
        mapper.registerModule((Module)this.jacksonModule);
        return mapper;
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public String toJson(Object object) {
        try {
            return this.jacksonMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to serialize object of type " + object.getClass().getName() + " into JSON!", e);
        }
    }

    public <T> T fromJson(String json, Class<T> targetClazz) {
        try {
            return (T)this.jacksonMapper.readValue(json, targetClazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to deserialize object of type " + targetClazz.getName() + " into JSON!", e);
        }
    }
}

