/*
 * Decompiled with CFR 0.152.
 */
package de.adesso.wickedcharts.chartjs.chartoptions.colors;

import de.adesso.wickedcharts.chartjs.chartoptions.colors.Color;
import java.io.Serializable;

public class HexColor
extends Color
implements Serializable {
    private int red;
    private int green;
    private int blue;

    public HexColor(int red, int green, int blue) {
        this.setRed(red);
        this.setGreen(green);
        this.setBlue(blue);
    }

    public HexColor(String hexColor) {
        if (!hexColor.matches("^#[0-9a-fA-F]{6}$")) {
            throw new IllegalArgumentException("Invalid hex color format: " + hexColor + ". A hex color must be of the format \"^#[0-9a-fA-F]{6}$\".");
        }
        String red_s = Character.toString(hexColor.charAt(1)) + Character.toString(hexColor.charAt(2));
        this.red = Integer.parseInt(red_s, 16);
        String green_s = Character.toString(hexColor.charAt(3)) + Character.toString(hexColor.charAt(4));
        this.green = Integer.parseInt(green_s, 16);
        String blue_s = Character.toString(hexColor.charAt(5)) + Character.toString(hexColor.charAt(6));
        this.blue = Integer.parseInt(blue_s, 16);
    }

    public HexColor setRed(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Color value can only be in the range 0-255");
        }
        this.red = value;
        return this;
    }

    public HexColor setGreen(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Color value can only be in the range 0-255");
        }
        this.green = value;
        return this;
    }

    public HexColor setBlue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Color value can only be in the range 0-255");
        }
        this.blue = value;
        return this;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public String toString() {
        return "HexColor(red=" + this.getRed() + ", green=" + this.getGreen() + ", blue=" + this.getBlue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HexColor)) {
            return false;
        }
        HexColor other = (HexColor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getRed() != other.getRed()) {
            return false;
        }
        if (this.getGreen() != other.getGreen()) {
            return false;
        }
        return this.getBlue() == other.getBlue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HexColor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getRed();
        result = result * 59 + this.getGreen();
        result = result * 59 + this.getBlue();
        return result;
    }
}

