/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdExecutor;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdReporter;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdWorkParameters;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import net.sourceforge.pmd.cpd.AnyLanguage;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import org.gradle.api.GradleException;
import org.gradle.workers.WorkAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CpdAction
implements WorkAction<CpdWorkParameters> {
    private static final Logger logger = LoggerFactory.getLogger(CpdAction.class);
    private final CpdExecutor executor;
    private final CpdReporter reporter;

    @Inject
    public CpdAction() {
        this.executor = new CpdExecutor();
        this.reporter = new CpdReporter();
    }

    CpdAction(CpdExecutor executor, CpdReporter reporter) {
        this.executor = executor;
        this.reporter = reporter;
    }

    public void execute() {
        List<Match> matches = this.executor.run(this.createCpdConfiguration((CpdWorkParameters)this.getParameters()), ((CpdWorkParameters)this.getParameters()).getSourceFiles().getFiles());
        this.reporter.generate((List)((CpdWorkParameters)this.getParameters()).getReportParameters().get(), matches);
        this.logResult(matches);
    }

    private CPDConfiguration createCpdConfiguration(CpdWorkParameters config) {
        CPDConfiguration result = new CPDConfiguration();
        result.setEncoding((String)config.getEncoding().get());
        result.setLanguage(this.createLanguage((String)config.getLanguage().get(), this.createLanguageProperties(config)));
        result.setMinimumTileSize(((Integer)config.getMinimumTokenCount().get()).intValue());
        result.setSkipDuplicates(((Boolean)config.getSkipDuplicateFiles().get()).booleanValue());
        result.setSkipLexicalErrors(((Boolean)config.getSkipLexicalErrors().get()).booleanValue());
        return result;
    }

    private void logResult(List<Match> matches) {
        if (matches.isEmpty()) {
            if (logger.isInfoEnabled()) {
                logger.info("No duplicates over {} tokens found.", ((CpdWorkParameters)this.getParameters()).getMinimumTokenCount().get());
            }
        } else {
            String message = "CPD found duplicate code.";
            CpdWorkParameters.Report report = (CpdWorkParameters.Report)((List)((CpdWorkParameters)this.getParameters()).getReportParameters().get()).get(0);
            if (report != null) {
                File reportUrl = report.getDestination();
                message = message + " See the report at " + this.asClickableFileUrl(reportUrl);
            }
            if (((Boolean)((CpdWorkParameters)this.getParameters()).getIgnoreFailures().get()).booleanValue()) {
                if (logger.isWarnEnabled()) {
                    logger.warn(message);
                }
            } else {
                throw new GradleException(message);
            }
        }
    }

    private Properties createLanguageProperties(CpdWorkParameters config) {
        Properties languageProperties = new Properties();
        if (((Boolean)config.getIgnoreAnnotations().get()).booleanValue()) {
            languageProperties.setProperty("ignore_annotations", "true");
        }
        if (((Boolean)config.getIgnoreIdentifiers().get()).booleanValue()) {
            languageProperties.setProperty("ignore_identifiers", "true");
        }
        if (((Boolean)config.getIgnoreLiterals().get()).booleanValue()) {
            languageProperties.setProperty("ignore_literals", "true");
        }
        languageProperties.setProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.toString((Boolean)config.getSkipBlocks().get()));
        languageProperties.setProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", (String)config.getSkipBlocksPattern().get());
        return languageProperties;
    }

    private Language createLanguage(String language, Properties languageProperties) {
        Language result = LanguageFactory.createLanguage((String)language, (Properties)languageProperties);
        logger.info("Using CPD language class '{}' for checking duplicates.", (Object)result);
        if (result instanceof AnyLanguage) {
            logger.warn("Could not detect CPD language for '{}', using 'any' as fallback language.", (Object)language);
        }
        return result;
    }

    private String asClickableFileUrl(File path) {
        try {
            return new URI("file", "", path.toURI().getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

