/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdExecutionConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.cpd.AnyLanguage;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class CpdExecutor {
    private static final Logger logger = Logging.getLogger(CpdExecutor.class);
    private final CPDConfiguration cpdConfig = new CPDConfiguration();
    private final Collection<File> sourceFiles;

    CpdExecutor(CpdExecutionConfiguration config) {
        this.cpdConfig.setEncoding(config.getEncoding());
        this.cpdConfig.setLanguage(this.createLanguage(config.getLanguage(), this.createLanguageProperties(config)));
        this.cpdConfig.setMinimumTileSize(config.getMinimumTokenCount());
        this.cpdConfig.setSkipDuplicates(config.isSkipDuplicateFiles());
        this.cpdConfig.setSkipLexicalErrors(config.isSkipLexicalErrors());
        this.sourceFiles = config.getSourceFiles();
    }

    private Properties createLanguageProperties(CpdExecutionConfiguration config) {
        Properties languageProperties = new Properties();
        if (config.isIgnoreAnnotations()) {
            languageProperties.setProperty("ignore_annotations", "true");
        }
        if (config.isIgnoreIdentifiers()) {
            languageProperties.setProperty("ignore_identifiers", "true");
        }
        if (config.isIgnoreLiterals()) {
            languageProperties.setProperty("ignore_literals", "true");
        }
        languageProperties.setProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocks", Boolean.toString(config.isSkipBlocks()));
        languageProperties.setProperty("net.sourceforge.pmd.cpd.Tokenizer.skipBlocksPattern", config.getSkipBlocksPattern());
        return languageProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Language createLanguage(String language, Properties languageProperties) {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CpdExecutor.class.getClassLoader());
            Language result = LanguageFactory.createLanguage((String)language, (Properties)languageProperties);
            logger.info("Using CPD language class '{}' for checking duplicates.", (Object)result);
            if (result instanceof AnyLanguage) {
                logger.warn("Could not detect CPD language for '{}', using 'any' as fallback language.", (Object)language);
            }
            Language language2 = result;
            return language2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
    }

    List<Match> run() {
        if (logger.isInfoEnabled()) {
            logger.info("Starting CPD, minimumTokenCount is {}", (Object)this.cpdConfig.getMinimumTileSize());
        }
        try {
            CPD cpd = new CPD(this.cpdConfig);
            this.tokenizeSourceFiles(cpd);
            this.analyzeSourceCode(cpd);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(cpd.getMatches(), 16), false).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new GradleException("Exception during CPD execution: " + e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            throw new GradleException(t.getMessage(), t);
        }
    }

    private void tokenizeSourceFiles(CPD cpd) throws IOException {
        for (File file : this.sourceFiles) {
            if (logger.isDebugEnabled()) {
                logger.debug("Tokenize {}", (Object)file.getAbsolutePath());
            }
            cpd.add(file);
        }
    }

    private void analyzeSourceCode(CPD cpd) {
        if (logger.isInfoEnabled()) {
            logger.info("Starting to analyze code");
        }
        long start = System.currentTimeMillis();
        cpd.go();
        long stop = System.currentTimeMillis();
        long timeTaken = stop - start;
        if (logger.isInfoEnabled()) {
            logger.info("Successfully analyzed code - took {} milliseconds", (Object)timeTaken);
        }
    }
}

