/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdExecutionConfiguration;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdExecutor;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdReportConfiguration;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdReporter;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.inject.Inject;
import net.sourceforge.pmd.cpd.Match;
import org.gradle.api.GradleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpdAction
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CpdAction.class);
    private final CpdExecutionConfiguration executionConfig;
    private List<CpdReportConfiguration> reportConfigs;

    @Inject
    public CpdAction(CpdExecutionConfiguration executionConfig, List<CpdReportConfiguration> reportConfigs) {
        this.executionConfig = executionConfig;
        this.reportConfigs = reportConfigs;
    }

    @Override
    public void run() {
        CpdExecutor executor = new CpdExecutor(this.executionConfig);
        CpdReporter reporter = new CpdReporter(this.reportConfigs);
        List<Match> matches = executor.run();
        reporter.generate(matches);
        this.logResult(matches);
    }

    private void logResult(List<Match> matches) {
        if (matches.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("No duplicates over {} tokens found.", (Object)this.executionConfig.getMinimumTokenCount());
            }
        } else {
            String message = "CPD found duplicate code.";
            CpdReportConfiguration report = this.reportConfigs.get(0);
            if (report != null) {
                File reportUrl = report.getDestination();
                message = message + " See the report at " + this.asClickableFileUrl(reportUrl);
            }
            if (this.executionConfig.isIgnoreFailures()) {
                if (log.isWarnEnabled()) {
                    log.warn(message);
                }
            } else {
                throw new GradleException(message);
            }
        }
    }

    private String asClickableFileUrl(File path) {
        try {
            return new URI("file", "", path.toURI().getPath(), null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

