/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.dominate;

import android.app.Application;
import android.content.ContentProvider;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import dalvik.system.DexClassLoader;
import dc.android.common.PluginContext;
import dc.android.libs.dominate.PluginLoadInstance;
import dc.common.Logger;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class HookApplicationUtils {
    private static String delegateApplicationName;
    private static volatile boolean isInit;
    private static Application delegateApplication;

    public static void init(String apkFilePath, Application proxyApplication) {
        if (isInit) {
            return;
        }
        HookApplicationUtils.preloadMeta(apkFilePath);
        HookApplicationUtils.setDelegateApplication(proxyApplication);
    }

    private static void preloadMeta(String apkFilePath) {
        try {
            Class<?> packageParserClass = Class.forName("android.content.pm.PackageParser");
            Object packageParser = packageParserClass.newInstance();
            Method parsePackageMethod = packageParserClass.getDeclaredMethod("parsePackage", File.class, Integer.TYPE);
            parsePackageMethod.setAccessible(true);
            Object packageParser$package = parsePackageMethod.invoke(packageParser, new File(apkFilePath), 2);
            Class<?> packageParser$package_Class = packageParser$package.getClass();
            Field mAppMetaDataFiled = packageParser$package_Class.getDeclaredField("mAppMetaData");
            mAppMetaDataFiled.setAccessible(true);
            Bundle mAppMetaData = (Bundle)mAppMetaDataFiled.get(packageParser$package);
            Logger.w((Object[])new Object[]{"HookApplicationUtils", "preloadMeta", mAppMetaData});
            if (mAppMetaData != null && mAppMetaData.containsKey(PluginContext.META_APPLICATION)) {
                delegateApplicationName = mAppMetaData.getString(PluginContext.META_APPLICATION);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.w((Object[])new Object[]{"HookApplicationUtils", "preloadMeta", delegateApplicationName});
    }

    public static Application setDelegateApplication(Application application) {
        if (TextUtils.isEmpty((CharSequence)delegateApplicationName)) {
            return application;
        }
        try {
            Context contextImpl = application.getBaseContext();
            DexClassLoader classLoader = PluginLoadInstance.getInstance().getDexClassLoader();
            Class<?> applicationClass = classLoader.loadClass(delegateApplicationName);
            delegateApplication = (Application)applicationClass.newInstance();
            Method attachMethod = Application.class.getDeclaredMethod("attach", Context.class);
            attachMethod.setAccessible(true);
            attachMethod.invoke((Object)delegateApplication, contextImpl);
            Class<?> contextImplClass = contextImpl.getClass();
            Method setOuterContextMethod = contextImplClass.getDeclaredMethod("setOuterContext", Context.class);
            setOuterContextMethod.setAccessible(true);
            setOuterContextMethod.invoke((Object)contextImpl, delegateApplication);
            Field loadedApkField = contextImplClass.getDeclaredField("mPackageInfo");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(contextImpl);
            Class<?> loadedApkClass = Class.forName("android.app.LoadedApk");
            Field mApplicationField = loadedApkClass.getDeclaredField("mApplication");
            mApplicationField.setAccessible(true);
            mApplicationField.set(loadedApk, delegateApplication);
            Field mMainThreadField = contextImplClass.getDeclaredField("mMainThread");
            mMainThreadField.setAccessible(true);
            Object mMainThread = mMainThreadField.get(contextImpl);
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Field mInitialApplicationField = activityThreadClass.getDeclaredField("mInitialApplication");
            mInitialApplicationField.setAccessible(true);
            mInitialApplicationField.set(mMainThread, delegateApplication);
            Field mAllApplicationsField = activityThreadClass.getDeclaredField("mAllApplications");
            mAllApplicationsField.setAccessible(true);
            ArrayList mAllApplications = (ArrayList)mAllApplicationsField.get(mMainThread);
            mAllApplications.remove(application);
            mAllApplications.add(delegateApplication);
            Field mApplicationInfoField = loadedApkClass.getDeclaredField("mApplicationInfo");
            mApplicationInfoField.setAccessible(true);
            ApplicationInfo applicationInfo = (ApplicationInfo)mApplicationInfoField.get(loadedApk);
            applicationInfo.className = delegateApplicationName;
            delegateApplication.onCreate();
            HookApplicationUtils.replaceContentProvider(mMainThread, delegateApplication);
            isInit = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return delegateApplication != null ? delegateApplication : application;
    }

    private static void replaceContentProvider(Object activityThread, Application delegateApplication) {
        try {
            Field mProviderMapField = activityThread.getClass().getDeclaredField("mProviderMap");
            mProviderMapField.setAccessible(true);
            Map mProviderMap = (Map)mProviderMapField.get(activityThread);
            Set entrySet = mProviderMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Object providerClientRecord = entry.getValue();
                Field mLocalProviderField = providerClientRecord.getClass().getDeclaredField("mLocalProvider");
                mLocalProviderField.setAccessible(true);
                ContentProvider contentProvider = (ContentProvider)mLocalProviderField.get(providerClientRecord);
                if (contentProvider == null) continue;
                Field contextField = Class.forName("android.content.ContentProvider").getDeclaredField("mContext");
                contextField.setAccessible(true);
                contextField.set(contentProvider, delegateApplication);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        isInit = false;
    }
}

