/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dc.android.common.activity.BaseActivity;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionProcessUtils;

public class PermissionActivity
extends BaseActivity {
    private static AbsPermissionCallback cb;

    public static void request(Context context, String[] permissions, AbsPermissionCallback callback) {
        if (PermissionProcessUtils.checkBlock(callback)) {
            return;
        }
        cb = callback;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra("var1", permissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (!intent.hasExtra("var1")) {
            return;
        }
        String[] permissions = this.getIntent().getStringArrayExtra("var1");
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, 101);
        }
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (101 != requestCode) {
            return;
        }
        PermissionProcessUtils.showResult(((Object)((Object)this)).getClass().getSimpleName(), permissions, grantResults);
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = this.shouldShowRequestPermissionRationale(permissions[i]);
        }
        PermissionProcessUtils.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale, cb);
        this.finish();
    }
}

