package dc.android.libs.permission;

import android.annotation.TargetApi;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentManager;
import dc.android.bridge.fragment.BaseFragment;

import static dc.android.common.PermissionOpcode.REQ_PERMISSION;

/**
 * @author senrsl
 * @ClassName: PermissionFragment
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/9/10 4:59 PM
 */
public class PermissionFragment extends BaseFragment {

    private String[] arrPermission;
    private AbsPermissionCallback cbLocal;
    private FragmentManager fragmentManager;

    public void init(FragmentManager fragmentManager, String[] arrPermission, AbsPermissionCallback cbLocal) {
        this.fragmentManager = fragmentManager;
        this.arrPermission = arrPermission;
        this.cbLocal = cbLocal;

        attach();
    }

    public static void request(FragmentManager fragmentManager, String[] arrPermission, AbsPermissionCallback cbLocal) {

        if (PermissionProcessUtils.checkBlock(cbLocal)) return;

        PermissionFragment fragment = new PermissionFragment();
        fragment.init(fragmentManager, arrPermission, cbLocal);
    }

    @Override
    protected void initData() {
        super.initData();

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) requestPermissions(arrPermission, REQ_PERMISSION);
    }

    @TargetApi(Build.VERSION_CODES.M)
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (REQ_PERMISSION != requestCode) return;

        PermissionProcessUtils.showResult(getClass().getSimpleName(), permissions, grantResults);

        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = shouldShowRequestPermissionRationale(permissions[i]);
        }
        PermissionProcessUtils.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale, cbLocal);

        detach();
    }


    private void attach() {
        fragmentManager
                .beginTransaction()
                .add(this, getClass().getSimpleName())
                .commitNow();
    }

    private void detach() {
        fragmentManager
                .beginTransaction()
                .remove(this)
                .commitNow();
    }
}
