package dc.android.libs.permission;

import java.util.ArrayList;
import java.util.List;

import android.content.pm.PackageManager;
import android.os.Build;
import dc.android.common.BridgeContext;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: PermissionProcessUtils
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/9/11 3:58 PM
 */
class PermissionProcessUtils {

    //@TargetApi(Build.VERSION_CODES.M)
    static void showResult(String tag, String[] permissions, int[] grantResults) {
        if (BridgeContext.isReport) return;
        StringBuffer sb = new StringBuffer(tag);
        for (String permision : permissions) {
            sb.append(BridgeContext.TAB);
            sb.append(permision);
        }

        for (int result : grantResults) {
            sb.append(BridgeContext.TAB);
            sb.append(result);
        }

        Logger.w(sb.toString());
    }

    //@TargetApi(Build.VERSION_CODES.M)
    static void onRequestPermissionsResult(String[] permissions, int[] grantResults, boolean[] shouldShowRequestPermissionRationale, AbsPermissionCallback cb) {
        List<String> listGrant = new ArrayList<>();
        List<String> listDenied = new ArrayList<>();
        List<String> listRationale = new ArrayList<>();
        int length = permissions.length;
        for (int i = 0; i < length; i++) {
            if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                if (shouldShowRequestPermissionRationale[i] == true) {
                    listRationale.add(permissions[i]);
                } else {
                    listDenied.add(permissions[i]);
                }
            } else {
                listGrant.add(permissions[i]);
            }
        }
        cb.setList(listGrant, listDenied, listRationale);
        cb.onResult(listGrant.size() == length, !listDenied.isEmpty(), !listRationale.isEmpty());
    }

    /**
     * 是否需要请求权限
     *
     * @return
     */
    static boolean isNeedRequest() {
        return Build.VERSION.SDK_INT >= Build.VERSION_CODES.M;
    }

    /**
     * 阻断检查
     *
     * @return
     */
    static boolean checkBlock(AbsPermissionCallback cb) {
        if (isNeedRequest()) return false;

        cb.onResult(true, false, false);

        return true;
    }

}
