package dc.android.libs.permission;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

/**
 * @author senrsl
 * @ClassName: PermissionCheckUtils
 * @Package: dc.android.libs.permission
 * @CreateTime: 2020/5/15 3:23 PM
 */
public class PermissionCheckUtils {

    /**
     * 已授予权限校验
     *
     * @param ctx
     * @param permissions
     * @param cb
     * @return
     */
    public static boolean checkGrant(@NonNull Context ctx, String[] permissions, @Nullable AbsPermissionCallback cb) {
        List<String> listGrant = new ArrayList<>();
        List<String> listDenied = new ArrayList<>();
        List<String> listRationale = new ArrayList<>();

        for (String permission : permissions) {
            switch (ContextCompat.checkSelfPermission(ctx, permission)) {
                case PackageManager.PERMISSION_GRANTED:
                    listGrant.add(permission);
                    break;
                case PackageManager.PERMISSION_DENIED:
                    listDenied.add(permission);
                    break;
            }
        }

        boolean isAllGrant = listGrant.size() == permissions.length;
        if (null != cb) {
            cb.setList(listGrant, listDenied, listRationale);
            cb.onResult(isAllGrant, !listDenied.isEmpty(), !listRationale.isEmpty());
        }

        if (isAllGrant) return true;

        return false;
    }

}
