/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.permission;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import dc.android.bridge.fragment.BaseFragment;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionProcessUtils;

public class PermissionFragment
extends BaseFragment {
    private String[] arrPermission;
    private AbsPermissionCallback cbLocal;
    private FragmentManager fragmentManager;

    public void init(FragmentManager fragmentManager, String[] arrPermission, AbsPermissionCallback cbLocal) {
        this.fragmentManager = fragmentManager;
        this.arrPermission = arrPermission;
        this.cbLocal = cbLocal;
        this.attach();
    }

    public static void request(FragmentManager fragmentManager, String[] arrPermission, AbsPermissionCallback cbLocal) {
        PermissionFragment fragment = new PermissionFragment();
        fragment.init(fragmentManager, arrPermission, cbLocal);
    }

    protected void initData() {
        super.initData();
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(this.arrPermission, 101);
        }
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (101 != requestCode) {
            return;
        }
        PermissionProcessUtils.showResult(((Object)((Object)this)).getClass().getSimpleName(), permissions, grantResults);
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = this.shouldShowRequestPermissionRationale(permissions[i]);
        }
        PermissionProcessUtils.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale, this.cbLocal);
        this.detach();
    }

    private void attach() {
        this.fragmentManager.beginTransaction().add((Fragment)this, ((Object)((Object)this)).getClass().getSimpleName()).commitNow();
    }

    private void detach() {
        this.fragmentManager.beginTransaction().remove((Fragment)this).commitNow();
    }
}

