/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionActivity;
import dc.android.libs.permission.PermissionFragment;

public class PermissionUtils {
    private AbsPermissionCallback cb;
    private String[] permissions;
    private Context context;
    private FragmentManager fragmentManager;

    public PermissionUtils(Context context) {
        this.context = context;
    }

    public PermissionUtils(@NonNull FragmentActivity activity) {
        this.fragmentManager = activity.getSupportFragmentManager();
    }

    public PermissionUtils(@NonNull Fragment fragment) {
        this.fragmentManager = fragment.getChildFragmentManager();
    }

    public static PermissionUtils with(Context context) {
        PermissionUtils permisson = new PermissionUtils(context);
        return permisson;
    }

    public static PermissionUtils with(FragmentActivity activity) {
        PermissionUtils permisson = new PermissionUtils(activity);
        return permisson;
    }

    public static PermissionUtils with(Fragment fragment) {
        PermissionUtils permisson = new PermissionUtils(fragment);
        return permisson;
    }

    public PermissionUtils permisson(String[] permissons) {
        this.permissions = permissons;
        return this;
    }

    public PermissionUtils callback(AbsPermissionCallback cb) {
        this.cb = cb;
        return this;
    }

    public void request() {
        if (this.permissions == null || this.permissions.length <= 0) {
            return;
        }
        if (null != this.context) {
            PermissionActivity.request(this.context, this.permissions, this.cb);
        } else if (null != this.fragmentManager) {
            PermissionFragment.request(this.fragmentManager, this.permissions, this.cb);
        }
    }
}

