package dc.android.libs.browser;

import org.json.JSONException;
import org.json.JSONObject;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import dc.common.Logger;
import dc.common.utils.StringUtils;

/**
 * @author senrsl
 * @ClassName: JavascriptFunction
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/9/29 上午11:14
 */
public class BaseJavascriptFunction {
    protected Context mContext;

//    @Override
//    public void onJsFunctionCalled(String tag) {
//    }

    public BaseJavascriptFunction(Context context) {
        this.mContext = context;

        Logger.w("init JavascriptFunction");
    }

    /**
     * 网页画出边界后是否可以回弹（bounces）
     */
    @JavascriptInterface
    public void shouldBounces(String json) {
        // Android暂不处理，主要用于IOS设备
    }

    /**
     * 解析Json对象
     */
    protected JSONObject parseJson(String json) {
        JSONObject jsonObject = null;
        try {
            if (!StringUtils.isEmpty(json)) jsonObject = new JSONObject(json);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }


    /**
     * 刷新当前Web界面显示的Title
     */
    @JavascriptInterface
    public void updateTitle(String json) {
        Logger.w(json);
        if (TextUtils.isEmpty(json)) {
            return;
        }
    }

}
