package dc.android.libs.browser;

import java.util.List;

import android.content.Intent;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;
import dc.android.bridge.fragment.BaseFragment;
import dc.android.common.BridgeContext;
import dc.android.common.BridgeOpcode;
import dc.android.common.utils.SharePreferencesUtils;
import dc.common.Logger;

import static dc.android.libs.browser.BrowserContext.KEY_WEB_FONT_SIZE;
import static dc.android.libs.browser.BrowserContext.WEB_LEVEL_SIZE_NORMAL;

/**
 * @author senrsl
 * @ClassName: BaseBrowserFragment
 * @Package: dc.android.libs.browser
 * @CreateTime: 2018/12/24 11:31 AM
 */
public abstract class BaseBrowserFragment extends BaseFragment {

    protected TextView tvTitle;
    protected ProgressBar progressBar;

    protected IBaseBrowserManager browserManager;

//    BrowserLocalManager localManager;

    BaseJavascriptFunction function;
    String exploreName;
    List<KeyValueBean> listCookie;
    IBaseBrowserManager.LongClickCallback cbClickLong;

    public void init(TextView tvTitle, BaseJavascriptFunction function, String exploreName,
                     List<KeyValueBean> listCookie, IBaseBrowserManager.LongClickCallback cbClickLong) {
        this.tvTitle = tvTitle;
        this.function = function;
        this.exploreName = exploreName;
        this.listCookie = listCookie;
        this.cbClickLong = cbClickLong;
    }


    protected <T extends View> T findView() {
        progressBar = getView().findViewById(R.id.pb_loading);
        return getView().findViewById(R.id.webview);
    }

    @Override
    protected void initData() {
        super.initData();
        browserManager.initSettings();
        browserManager.setJavascript(function, exploreName);
        browserManager.syncCookie(listCookie);
        browserManager.setLongClickCallback(cbClickLong);

        String url = getArguments().getString(BridgeContext.KEY_VAR_1);
        loadPre(url);
        setFontSize(new SharePreferencesUtils(activity).getSharedPreferencesValue(KEY_WEB_FONT_SIZE, WEB_LEVEL_SIZE_NORMAL));
    }


    @Override
    public void refreshData() {
        super.refreshData();
        reload();
    }

    protected void loadPre(String url) {
        Logger.w(url);
        if (null != url) {
            load(url);
        } else {
            Logger.w(activity, getString(R.string.failed_get));
        }
    }

    protected abstract void load(String url);

    protected void reload() {
        browserManager.reload();
    }


    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Logger.w(getClass().getSimpleName(), requestCode, resultCode, data);
        switch (resultCode) {
            case BridgeOpcode.UPDATE:
                reload();
            default:
                break;
        }
    }

    public boolean back() {
        return null == browserManager ? false : browserManager.back();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        destroy();
    }

    protected void destroy() {
        if (null != browserManager) browserManager.destroy();
    }

    public abstract String getUri();

    public void reloadPage() {
        reload();
    }

    public void openInBrowser() {
        browserManager.openInBrowser(getUri());
    }

    public abstract void setFontSize(int sizeLevel);

    public void evaluateJavascript(String function, String[] arrParam, ValueCallback<String> cb) {

    }

    public interface ValueCallback<T> {
        void onReceiveValue(T value);
    }

}
