package dc.android.libs.browser.tbs;

import java.util.ArrayList;
import java.util.List;

import dc.android.libs.browser.R;
import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: TbsWebChromeClient
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/9/29 下午7:20
 */
public class TbsWebChromeClient extends WebChromeClient {

    private Context ctx;
    private ProgressBar progressBar;

    public TbsWebChromeClient(Context ctx, ProgressBar progressBar) {
        this.ctx = ctx;
        this.progressBar = progressBar;
    }

    View myVideoView;
    View myNormalView;
    IX5WebChromeClient.CustomViewCallback callback;

    @Override
    public boolean onJsConfirm(WebView arg0, String arg1, String arg2, JsResult arg3) {
        return super.onJsConfirm(arg0, arg1, arg2, arg3);
    }

    @Override
    public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback customViewCallback) {
        hideExt(view);
        FrameLayout normalView = getActivity().findViewById(R.id.webview);
        ViewGroup viewGroup = (ViewGroup) normalView.getParent();
        viewGroup.removeView(normalView);
        viewGroup.addView(view);
        myVideoView = view;
        myNormalView = normalView;
        callback = customViewCallback;

        setStatusBarVisible(false);
    }


    @Override
    public void onHideCustomView() {
        if (callback != null) {
            callback.onCustomViewHidden();
            callback = null;
        }
        if (myVideoView != null) {
            ViewGroup viewGroup = (ViewGroup) myVideoView.getParent();
            viewGroup.removeView(myVideoView);
            viewGroup.addView(myNormalView);
        }

        setStatusBarVisible(true);
    }

    private void hideExt(View view) {
        //12：缓存 13：小窗 14：分享 23：横竖屏
        //size等于26是先点播放，再点全屏
        //size等于29是先点全屏，再点播放
        List<View> list = getAllChildViews(view);
//        if (list.size() == 26) {
//            list.get(12).setVisibility(View.INVISIBLE);
//            list.get(13).setVisibility(View.INVISIBLE);
//            list.get(14).setVisibility(View.INVISIBLE);
//            list.get(23).setVisibility(View.INVISIBLE);
//        } else if (list.size() == 29) {
//            list.get(15).setVisibility(View.INVISIBLE);
//            list.get(16).setVisibility(View.INVISIBLE);
//            list.get(17).setVisibility(View.INVISIBLE);
//            list.get(26).setVisibility(View.INVISIBLE);
//        }
        for (View v : list) {
            Logger.w((v));
            if (v instanceof TextView && ctx.getString(R.string.cache).equals(((TextView) v).getText()))
                v.setVisibility(View.INVISIBLE);
        }
    }

    private List<View> getAllChildViews(View view) {
        List<View> list = new ArrayList<>();
        if (view instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup) view;
            for (int i = 0; i < vp.getChildCount(); i++) {
                View child = vp.getChildAt(i);
                Logger.w("tbsView:" + child.getClass().getName());
                list.add(child);
                list.addAll(getAllChildViews(child));
            }
        }
        return list;
    }

    private void setStatusBarVisible(boolean show) {
        if (show) {
            int uiFlags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE;
            uiFlags |= 0x00001000;
            getActivity().getWindow().getDecorView().setSystemUiVisibility(uiFlags);
        } else {
            int uiFlags = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                    | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_FULLSCREEN;
            uiFlags |= 0x00001000;
            getActivity().getWindow().getDecorView().setSystemUiVisibility(uiFlags);
        }
    }

    private Activity getActivity() {
        return ((Activity) ctx);
    }

    @Override
    public boolean onJsAlert(WebView arg0, String arg1, String arg2,
                             JsResult arg3) {
        return super.onJsAlert(null, arg1, arg2, arg3);
    }

    @Override
    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView newView = new WebView(view.getContext());
        newView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }
        });
        WebView.WebViewTransport transport = (WebView.WebViewTransport) resultMsg.obj;
        transport.setWebView(view);
        resultMsg.sendToTarget();
        return true;
    }

    public void onProgressChanged(WebView view, int progress) {
        super.onProgressChanged(view, progress);
        if (null != progressBar) progressBar.setProgress(progress);
    }
}
