/*
 * Decompiled with CFR 0.152.
 */
package dc.android.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;

public class FlowLayout
extends ViewGroup {
    private ArrayList<Line> lineList = new ArrayList();
    private int childViewHorizontalPadding = 0;
    private int childViewVerticalPadding = 0;
    private boolean isLineFull = false;

    public FlowLayout(Context context) {
        super(context);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.lineList.clear();
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int contentWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        Line line = new Line();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View childView = this.getChildAt(i);
            childView.measure(0, 0);
            if (line.getList().size() == 0) {
                line.addLineView(childView);
                continue;
            }
            if (line.getWidth() + this.childViewHorizontalPadding + childView.getMeasuredWidth() > contentWidth) {
                this.lineList.add(line);
                line = new Line();
                line.addLineView(childView);
                continue;
            }
            line.addLineView(childView);
        }
        this.lineList.add(line);
        int height = this.getPaddingTop() + this.getPaddingBottom() + (this.lineList.size() - 1) * this.childViewVerticalPadding;
        for (Line l : this.lineList) {
            height += l.getHeight();
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int left = 0;
        int top = this.getPaddingTop();
        int right = 0;
        int bottom = 0;
        for (int k = 0; k < this.lineList.size(); ++k) {
            Line line = this.lineList.get(k);
            if (k > 0) {
                top += this.lineList.get(k - 1).getHeight() + this.childViewVerticalPadding;
            }
            ArrayList<View> viewlist = line.getList();
            int perSpacing = 0;
            if (viewlist.size() > 0) {
                perSpacing = this.getLineRemainSpacing(line) / viewlist.size();
            }
            for (int i = 0; i < viewlist.size(); ++i) {
                View childView = viewlist.get(i);
                if (this.isLineFull) {
                    int measureWidth = View.MeasureSpec.makeMeasureSpec((int)(childView.getMeasuredWidth() + perSpacing), (int)0x40000000);
                    childView.measure(measureWidth, 0);
                }
                line.reSetWidth();
                if (i == 0) {
                    left = this.getPaddingLeft();
                    right = left + childView.getMeasuredWidth();
                    bottom = top + childView.getMeasuredHeight();
                    childView.layout(left, top, right, bottom);
                    continue;
                }
                View preView = viewlist.get(i - 1);
                left = preView.getRight() + this.childViewHorizontalPadding;
                right = left + childView.getMeasuredWidth();
                bottom = top + childView.getMeasuredHeight();
                childView.layout(left, top, right, bottom);
            }
        }
    }

    private int getLineRemainSpacing(Line line) {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - line.getWidth();
    }

    public void setChildViewHorizontalPadding(int childViewHorizontalPadding) {
        this.childViewHorizontalPadding = childViewHorizontalPadding;
    }

    public void setChildViewVerticalPadding(int childViewVerticalPadding) {
        this.childViewVerticalPadding = childViewVerticalPadding;
    }

    public void setLineFull(boolean lineFull) {
        this.isLineFull = lineFull;
    }

    public class Line {
        private ArrayList<View> viewListOfLine = new ArrayList();
        private int width = 0;
        private int height = 0;

        public void addLineView(View childView) {
            if (!this.viewListOfLine.contains(childView)) {
                this.viewListOfLine.add(childView);
                this.width = this.viewListOfLine.size() == 1 ? childView.getMeasuredWidth() : (this.width += childView.getMeasuredWidth() + FlowLayout.this.childViewHorizontalPadding);
                this.height = Math.max(this.height, childView.getMeasuredHeight());
            }
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public ArrayList<View> getList() {
            return this.viewListOfLine;
        }

        public void reSetWidth() {
            this.width = 0;
            for (View view : this.viewListOfLine) {
                this.width += view.getMeasuredWidth();
            }
            this.width += (this.viewListOfLine.size() - 1) * FlowLayout.this.childViewHorizontalPadding;
        }
    }
}

