/*
 * Decompiled with CFR 0.152.
 */
package dc.android.common.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Movie;
import android.graphics.drawable.Drawable;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.RawRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import dc.android.common.BaseApplication;

public class ResourceUtils {
    public static String getString(@StringRes int resId) {
        try {
            return BaseApplication.getContext().getString(resId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getString(@StringRes int resId, Object ... args) {
        try {
            return BaseApplication.getContext().getString(resId, args);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static CharSequence getText(@StringRes int resId) {
        try {
            return BaseApplication.getContext().getText(resId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String[] getStringArray(@ArrayRes int resId) {
        try {
            return BaseApplication.getContext().getResources().getStringArray(resId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public static int[] getIntArray(@ArrayRes int resId) {
        try {
            return BaseApplication.getContext().getResources().getIntArray(resId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return new int[0];
        }
    }

    @ColorInt
    public static int getColor(@ColorRes int resId) {
        try {
            return ContextCompat.getColor((Context)BaseApplication.getContext(), (int)resId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            return -16777216;
        }
    }

    public static Drawable getDrawable(@DrawableRes int resId) {
        return ContextCompat.getDrawable((Context)BaseApplication.getContext(), (int)resId);
    }

    public static Bitmap getBitmap(int resId) {
        return BitmapFactory.decodeResource((Resources)BaseApplication.getContext().getResources(), (int)resId);
    }

    public static Bitmap getBitmap(String resPath) {
        return BitmapFactory.decodeFile((String)resPath);
    }

    public static Movie getMovie(@RawRes int resId) {
        return BaseApplication.getContext().getResources().getMovie(resId);
    }

    public static AssetManager getAssets() {
        return BaseApplication.getContext().getAssets();
    }
}

