package dc.android.bridge.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import dc.android.common.activity.BaseActivity;

/**
 * @author senrsl
 * @ClassName: BaseFragment
 * @Package: dc.android.base.fragment
 * @CreateTime: 2018/11/9 4:09 PM
 */
public class BaseFragment<T extends BaseActivity> extends Fragment {

    protected T activity;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        onAttachToContext(context);
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            onAttachToContext(activity);
        }
    }

    protected void onAttachToContext(Context context) {
        activity = (T) getActivity();
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        try {
            inflatView();
            initData();
            initAttach();
            refreshDataOnCreated();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void inflatView() {
    }

    protected void initData() {
    }

    protected void initAttach() {
    }

    @Override
    public void onStart() {
        super.onStart();
        if (null == activity) activity = (T) getActivity();
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            refreshDataOnVisible();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) refreshDataOnVisible();
    }

    protected void loadData() {
        refreshData();
    }

    /**
     * refreshOnCreate
     */
    public void refreshDataOnCreated() {
    }

    /**
     * refresh onVisible<br/>
     * apply 2 onResume & onHiddenChanged-!hidden
     */
    protected void refreshDataOnVisible() {
    }

    /**
     * lazy mode
     * 适用于主动请求拉取数据
     */
    public void refreshDataOnRequest() {
    }

    /**
     * 执行数据请求
     * refreshDataExec
     */
    public void refreshData() {

    }


    protected boolean isAvailable() {
        return null != activity && isAdded();
    }
}
