package dc.android.base.domain;

import android.os.Parcel;
import android.os.Parcelable;
import dc.android.common.domain.BaseBean;

/**
 * @author senrsl
 * @ClassName: KeyValueBean
 * @Package: dc.android.base.domain
 * @CreateTime: 2018/8/17 下午4:00
 */
public class KeyValueBean extends BaseBean implements Parcelable {
    private String key;
    private String value;

    public KeyValueBean() {
    }

    public KeyValueBean(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "KeyValueBean{" +
                "Key='" + key + '\'' +
                ", Value='" + value + '\'' +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(key);
        dest.writeString(value);
    }

    public static final Parcelable.Creator<KeyValueBean> CREATOR = new Creator<KeyValueBean>() {
        @Override
        public KeyValueBean createFromParcel(Parcel source) {
            return new KeyValueBean(source.readString(), source.readString());
        }

        @Override
        public KeyValueBean[] newArray(int size) {
            return new KeyValueBean[size];
        }
    };
}
