package dc.android.common.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import android.util.Base64;

/**
 * 基本加密配置，多级加密使用lib encrypt
 *
 * @author senrsl
 * @ClassName: EncryptUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2018/6/7 下午2:34
 */
public class EncryptUtils {

    public static String md5(byte[] bytes) throws NoSuchAlgorithmException {
        byte[] hash = MessageDigest.getInstance("MD5").digest(bytes);
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 0x10)
                hex.append("0");
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().toLowerCase();
    }

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeToString(bytes, Base64.DEFAULT);
    }

    public static String base64DecodeStr(String str) {
        return new String(base64Decode(str));
    }

    public static byte[] base64Decode(String str) {
        if (null == str || str.trim().length() == 0) return new byte[]{};
        return Base64.decode(str, Base64.DEFAULT);
    }

}
