package dc.android.common.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import dc.android.common.BridgeContext;
import dc.common.Logger;

/**
 * 使用margin定位控件位置
 *
 * @author senrsl
 * @ClassName: AutoMarginUtils
 * @Package: dc.android.common.utils
 * @CreateTime: 2018/6/4 上午11:07
 */
public class AutoMarginUtils {
    public static int displayWidth;
    public static int displayHeight;

    private static int designWidth;
    private static int designHeight;

    private static double textPixelsRate;

    public static void setSize(Context ctx, boolean hasStatusBar, int designWidth, int designHeight) {

        if (ctx == null || designWidth < 1 || designHeight < 1)
            return;

        Point point = ScreenUtils.getDisplayPoint(ctx);
        int width = point.x;
        int height = point.y;
//        Display display = act.getWindowManager().getDefaultDisplay();
//        int width = display.getWidth();
//        int height = display.getHeight();
        Logger.w("display  height is " + height + "  width is :" + width);

        if (hasStatusBar) {
            height -= getStatusBarHeight(ctx);
        }
        Logger.w("height is " + height + "  width is :" + width);

        AutoMarginUtils.displayWidth = width;
        AutoMarginUtils.displayHeight = height;

        AutoMarginUtils.designWidth = designWidth;
        AutoMarginUtils.designHeight = designHeight;

        double displayDiagonal = Math.sqrt(Math.pow(AutoMarginUtils.displayWidth, 2) + Math.pow(AutoMarginUtils.displayHeight, 2));
        double designDiagonal = Math.sqrt(Math.pow(AutoMarginUtils.designWidth, 2) + Math.pow(AutoMarginUtils.designHeight, 2));

        AutoMarginUtils.textPixelsRate = displayDiagonal / designDiagonal;

    }


    public static int getStatusBarHeight(Context context) {

        int result = 0;
        try {
            int resourceId = context.getResources().getIdentifier(
                    "status_bar_height", "dimen", "android");

            if (resourceId > 0) {
                result = context.getResources().getDimensionPixelSize(resourceId);
            }

        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

        Logger.w("status bar height is : " + result);
        return result;

    }


    public static void auto(Activity act) {

        if (act == null || displayWidth < 1 || displayHeight < 1)
            return;

        View view = act.getWindow().getDecorView();
        auto(view);
    }


    public static void auto(View view) {

        if (view == null || displayWidth < 1 || displayHeight < 1)
            return;

        AutoMarginUtils.autoTextSize(view);
        AutoMarginUtils.autoSize(view);
        AutoMarginUtils.autoPadding(view);
        AutoMarginUtils.autoMargin(view);


        if (view instanceof ViewGroup) {
            auto((ViewGroup) view);
        }


    }


    private static void auto(ViewGroup viewGroup) {

        int count = viewGroup.getChildCount();

        for (int i = 0; i < count; i++) {
            View child = viewGroup.getChildAt(i);

            if (child != null) {
                auto(child);
            }
        }

    }


    public static void autoMargin(View view) {

        if (!(view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams))
            return;


        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        if (lp == null)
            return;


        lp.leftMargin = getDisplayWidthValue(lp.leftMargin);
        lp.topMargin = getDisplayHeightValue(lp.topMargin);
        lp.rightMargin = getDisplayWidthValue(lp.rightMargin);
        lp.bottomMargin = getDisplayHeightValue(lp.bottomMargin);

    }


    public static void autoPadding(View view) {

        int l = view.getPaddingLeft();
        int t = view.getPaddingTop();
        int r = view.getPaddingRight();
        int b = view.getPaddingBottom();


        l = getDisplayWidthValue(l);
        t = getDisplayHeightValue(t);
        r = getDisplayWidthValue(r);
        b = getDisplayHeightValue(b);

        view.setPadding(l, t, r, b);
    }


    public static void autoSize(View view) {

        ViewGroup.LayoutParams lp = view.getLayoutParams();

        if (lp == null)
            return;

        boolean isSquare = false;
        if (lp.width == lp.height) {
            isSquare = true;
        }

        if (lp.width > 0) {
            lp.width = getDisplayWidthValue(lp.width);
        }

        if (lp.height > 0) {
            lp.height = getDisplayHeightValue(lp.height);
        }

        if (isSquare) {
            if (lp.width > lp.height) {
                lp.width = lp.height;
            } else {
                lp.height = lp.width;
            }
        }

    }


    public static void autoTextSize(View view) {

        if (view instanceof TextView) {

            double designPixels = ((TextView) view).getTextSize();
            double displayPixels = textPixelsRate * designPixels;

            ((TextView) view).setIncludeFontPadding(false);
            ((TextView) view).setTextSize(TypedValue.COMPLEX_UNIT_PX, (float) displayPixels);

        }

    }


    public static int getDisplayWidthValue(int designWidthValue) {

        if (Math.abs(designWidthValue) < 2) {
            return designWidthValue;
        } else if (designWidth == 0) {
            designWidth = BridgeContext.DESIGN_WIDTH;
        }

        return designWidthValue * displayWidth / designWidth;

    }


    public static int getDisplayHeightValue(int designHeightValue) {

        if (Math.abs(designHeightValue) < 2) {
            return designHeightValue;
        } else if (designHeight == 0) {
            designHeight = BridgeContext.DESIGN_HEIGHT;
        }

        return designHeightValue * displayHeight / designHeight;

    }

    public static float getDisplayTextSize(float designTextSize) {
        return (float) (AutoMarginUtils.textPixelsRate * designTextSize);
    }

    public static double getTextPixelsRate() {
        return textPixelsRate == 0 ? 1 : textPixelsRate;
    }
}
