package dc.android.bridge.fragment;

import dc.android.arch.present.BasePresenter;
import dc.android.arch.present.IBaseView;
import dc.android.common.activity.BaseActivity;

/**
 * @author senrsl
 * @ClassName: BasePresenterFragment
 * @Package: dc.android.bridge.fragment
 * @CreateTime: 2018/11/24 5:34 PM
 */
public class BasePresenterFragment<T extends BaseActivity, V extends IBaseView, P extends BasePresenter<V>> extends BaseFragment<T> {

    protected P presenter;


    @Override
    protected void initAttach() {
        super.initAttach();
        if (null != presenter) presenter.attachView(activity, (V) this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (null != presenter) presenter.detachView();
    }
}
