package dc.android.base.wrapper;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import dc.android.common.activity.BaseActivity;

/**
 * @author senrsl
 * @ClassName: HideInputWrapper
 * @Package: dc.android.base.wrapper
 * @CreateTime: 2019/4/24 7:00 PM
 */

@SuppressWarnings("Duplicates")
public class HideInputWrapper {


    private BaseActivity activity;

    public HideInputWrapper(BaseActivity activity) {
        this.activity = activity;
    }


    //    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        //Logger.w(ev.getAction(), dontHideInput(ev), isShouldHideInput(activity.getCurrentFocus(), ev), activity.getCurrentFocus());
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {

            if (dontHideInput(ev))
                if (isShouldHideInput(activity.getCurrentFocus(), ev)) hideSoftInput();
            return dispatchTouchEventSuper(ev);
        }
        // 必不可少，否则所有的组件都不会有TouchEvent了
        if (activity.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return activity.onTouchEvent(ev);
    }

    public boolean dispatchTouchEventSuper(MotionEvent ev) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            activity.onUserInteraction();
        }
        if (activity.getWindow().superDispatchTouchEvent(ev)) {
            return true;
        }
        return activity.onTouchEvent(ev);
    }

    protected void hideSoftInput() {
        InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm != null) {
            imm.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
//            hiddenNav();
            //ImmersiveUtils.hiddenNav(activity.getWindow().getDecorView());
        }
    }

    private boolean isShouldHideInput(View v, MotionEvent event) {
//        Logger.w("isShouldHideInput: " + (v instanceof EditText) + v.getId());
        if (v != null && (v instanceof EditText)) {
            int[] leftTop = {0, 0};
            //获取输入框当前的location位置
            v.getLocationInWindow(leftTop);
            int left = leftTop[0];
            int top = leftTop[1];
            int bottom = top + v.getHeight();
            int right = left + v.getWidth();
//            Logger.w(String.format("isShouldHideInput left:%d  right:%d   top: %d  bottom:%d ", left, right, top, bottom));
//            Logger.w(String.format("isShouldHideInputEvent x:%f  y:%f", event.getX(), event.getY()));
            if (event.getX() > left && event.getX() < right && event.getY() > top && event.getY() < bottom) {
                // 点击的是输入框区域，保留点击EditText的事件
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    protected boolean dontHideInput(MotionEvent ev) {
        return true;
    }

    //(x,y)是否在view的区域内
    protected boolean isTouchPointInView(View view, MotionEvent ev) {
        if (view == null) {
            return false;
        }
        int x = (int) ev.getRawX();
        int y = (int) ev.getRawY();
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getMeasuredWidth();
        int bottom = top + view.getMeasuredHeight();
        //view.isClickable() &&
        if (y >= top && y <= bottom && x >= left && x <= right) {
            return true;
        }
        return false;
    }


}
