/*
 * Decompiled with CFR 0.152.
 */
package dc.android.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.widget.PopupWindowCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.PopupWindow;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RelativePopupWindow
extends PopupWindow {
    public RelativePopupWindow(Context context) {
        super(context);
    }

    public RelativePopupWindow(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RelativePopupWindow(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=11)
    public RelativePopupWindow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public RelativePopupWindow() {
    }

    public RelativePopupWindow(View contentView) {
        super(contentView);
    }

    public RelativePopupWindow(int width, int height) {
        super(width, height);
    }

    public RelativePopupWindow(View contentView, int width, int height) {
        super(contentView, width, height);
    }

    public RelativePopupWindow(View contentView, int width, int height, boolean focusable) {
        super(contentView, width, height, focusable);
    }

    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos) {
        this.showOnAnchor(anchor, vertPos, horizPos, 0, 0);
    }

    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos, boolean fitInScreen) {
        this.showOnAnchor(anchor, vertPos, horizPos, 0, 0, fitInScreen);
    }

    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos, int x, int y) {
        this.showOnAnchor(anchor, vertPos, horizPos, x, y, true);
    }

    public void showOnAnchor(@NonNull View anchor, int vertPos, int horizPos, int x, int y, boolean fitInScreen) {
        this.setClippingEnabled(fitInScreen);
        View contentView = this.getContentView();
        contentView.measure(RelativePopupWindow.makeDropDownMeasureSpec(this.getWidth()), RelativePopupWindow.makeDropDownMeasureSpec(this.getHeight()));
        int measuredW = contentView.getMeasuredWidth();
        int measuredH = contentView.getMeasuredHeight();
        if (!fitInScreen) {
            int[] anchorLocation = new int[2];
            anchor.getLocationInWindow(anchorLocation);
            x += anchorLocation[0];
            y += anchorLocation[1] + anchor.getHeight();
        }
        switch (vertPos) {
            case 1: {
                y -= measuredH + anchor.getHeight();
                break;
            }
            case 4: {
                y -= measuredH;
                break;
            }
            case 0: {
                y -= anchor.getHeight() / 2 + measuredH / 2;
                break;
            }
            case 3: {
                y -= anchor.getHeight();
                break;
            }
        }
        switch (horizPos) {
            case 1: {
                x -= measuredW;
                break;
            }
            case 4: {
                x -= measuredW - anchor.getWidth();
                break;
            }
            case 0: {
                x += anchor.getWidth() / 2 - measuredW / 2;
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                x += anchor.getWidth();
            }
        }
        if (fitInScreen) {
            PopupWindowCompat.showAsDropDown((PopupWindow)this, (View)anchor, (int)x, (int)y, (int)0);
        } else {
            this.showAtLocation(anchor, 0, x, y);
        }
    }

    private static int makeDropDownMeasureSpec(int measureSpec) {
        return View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)measureSpec), (int)RelativePopupWindow.getDropDownMeasureSpecMode(measureSpec));
    }

    private static int getDropDownMeasureSpecMode(int measureSpec) {
        switch (measureSpec) {
            case -2: {
                return 0;
            }
        }
        return 0x40000000;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HorizontalPosition {
        public static final int CENTER = 0;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int ALIGN_LEFT = 3;
        public static final int ALIGN_RIGHT = 4;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerticalPosition {
        public static final int CENTER = 0;
        public static final int ABOVE = 1;
        public static final int BELOW = 2;
        public static final int ALIGN_TOP = 3;
        public static final int ALIGN_BOTTOM = 4;
    }
}

